% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/piv_plot.R
\name{piv_plot}
\alias{piv_plot}
\title{Plotting outputs from pivotal relabelling}
\usage{
piv_plot(
  y,
  mcmc,
  rel_est,
  par = c("mean", "sd", "weight", "all"),
  type = c("chains", "hist")
)
}
\arguments{
\item{y}{Data vector or matrix.}

\item{mcmc}{The ouptut of the raw MCMC sampling, as provided by \code{piv_MCMC}.}

\item{rel_est}{Pivotal estimates as provided by \code{piv_rel}.}

\item{par}{The parameters for which estimates are displayed. Choose among: \code{"mean"}, \code{"sd"}, \code{"weight"} and \code{"all"}.}

\item{type}{Type of plots required. Choose among: \code{"chains"},  \code{"hist"}.}
}
\description{
Plot and visualize MCMC outputs and posterior relabelled chains/estimates.
}
\examples{

# Fishery data
\dontrun{
library(bayesmix)
data(fish)
y <- fish[,1]
N <- length(y)
k <- 5
nMC <- 5000
res <- piv_MCMC(y = y, k = k, nMC = nMC)
rel <- piv_rel(mcmc=res, nMC = nMC)
piv_plot(y, res, rel, "chains")
piv_plot(y, res, rel, "estimates")
piv_plot(y, res, rel, "hist")
}

}
\author{
Leonardo Egidi \email{legidi@units.it}
}
