% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PivotCalculationGroup.R
\docType{class}
\name{PivotCalculationGroup}
\alias{PivotCalculationGroup}
\title{R6 class that defines a group of calculations.}
\format{
\code{\link[R6]{R6Class}} object.
}
\description{
The `PivotCalculationGroup` class is a container for multiple
`PivotCalculation` objects.  Every pivot table has at least
one pivot calculation group and this is sufficient for all
regular pivot tables.  Additional calculation groups are
typically only created for irregular/custom pivot tables.
See the "Irregular Layout" vignette for an example.
}
\examples{
# This class should only be created by the pivot table.
# It is not intended to be created outside of the pivot table.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{calculationGroupName}}{The name of the calculation group.}

\item{\code{defaultCalculationName}}{The name of the default calculation in this
calculation group.}

\item{\code{count}}{The number of calculations in this calculation group.}

\item{\code{calculations}}{A list containing the calculations in this group.}

\item{\code{visibleCount}}{The number of visible calculations in this calculation
group.}

\item{\code{visibleCalculations}}{A list containing the visible calculations in
this group.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PivotCalculationGroup-new}{\code{PivotCalculationGroup$new()}}
\item \href{#method-PivotCalculationGroup-isExistingCalculation}{\code{PivotCalculationGroup$isExistingCalculation()}}
\item \href{#method-PivotCalculationGroup-item}{\code{PivotCalculationGroup$item()}}
\item \href{#method-PivotCalculationGroup-getCalculation}{\code{PivotCalculationGroup$getCalculation()}}
\item \href{#method-PivotCalculationGroup-defineCalculation}{\code{PivotCalculationGroup$defineCalculation()}}
\item \href{#method-PivotCalculationGroup-asList}{\code{PivotCalculationGroup$asList()}}
\item \href{#method-PivotCalculationGroup-asJSON}{\code{PivotCalculationGroup$asJSON()}}
\item \href{#method-PivotCalculationGroup-asString}{\code{PivotCalculationGroup$asString()}}
\item \href{#method-PivotCalculationGroup-clone}{\code{PivotCalculationGroup$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotCalculationGroup-new"></a>}}
\if{latex}{\out{\hypertarget{method-PivotCalculationGroup-new}{}}}
\subsection{Method \code{new()}}{
Create a new `PivotCalculationGroup` object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotCalculationGroup$new(parentPivot, calculationGroupName = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parentPivot}}{The pivot table that this `PivotCalculationGroup`
instance belongs to.}

\item{\code{calculationGroupName}}{Calculation group unique name.
Recommendation: Do not have spaces in this name.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `PivotCalculationGroup` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotCalculationGroup-isExistingCalculation"></a>}}
\if{latex}{\out{\hypertarget{method-PivotCalculationGroup-isExistingCalculation}{}}}
\subsection{Method \code{isExistingCalculation()}}{
Check whether a calculation already exists in this calculation group.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotCalculationGroup$isExistingCalculation(calculationName = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{calculationName}}{group unique name.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
`TRUE` if a calculation with the specified name exists in
this calculation group object, `FALSE` otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotCalculationGroup-item"></a>}}
\if{latex}{\out{\hypertarget{method-PivotCalculationGroup-item}{}}}
\subsection{Method \code{item()}}{
Retrieve a calculation by index.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotCalculationGroup$item(index)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{An integer specifying the calculation to retrieve.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The calculation that exists at the specified index.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotCalculationGroup-getCalculation"></a>}}
\if{latex}{\out{\hypertarget{method-PivotCalculationGroup-getCalculation}{}}}
\subsection{Method \code{getCalculation()}}{
Retrieve a calculation by name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotCalculationGroup$getCalculation(calculationName = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{calculationName}}{The name of the calculation to retrieve.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The calculation with the specified name.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotCalculationGroup-defineCalculation"></a>}}
\if{latex}{\out{\hypertarget{method-PivotCalculationGroup-defineCalculation}{}}}
\subsection{Method \code{defineCalculation()}}{
Create a new `PivotCalculation` object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotCalculationGroup$defineCalculation(
  calculationName = NULL,
  caption = NULL,
  visible = TRUE,
  displayOrder = NULL,
  filters = NULL,
  format = NULL,
  fmtFuncArgs = NULL,
  dataName = NULL,
  type = "summary",
  valueName = NULL,
  summariseExpression = NULL,
  calculationExpression = NULL,
  calculationFunction = NULL,
  calcFuncArgs = NULL,
  basedOn = NULL,
  noDataValue = NULL,
  noDataCaption = NULL,
  headingBaseStyleName = NULL,
  headingStyleDeclarations = NULL,
  cellBaseStyleName = NULL,
  cellStyleDeclarations = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{calculationName}}{Calculation unique name.}

\item{\code{caption}}{Calculation display name}

\item{\code{visible}}{`TRUE` to show the calculation in the pivot table or `FALSE`
to hide it.  Hidden calculations are typically used as base values for
other calculations.}

\item{\code{displayOrder}}{The order the calculations are displayed in the
pivot table.}

\item{\code{filters}}{Any additional data filters specific to this calculation.
This can be a `PivotFilters` object that further restricts the data for the
calculation or a list of individual `PivotFilter` objects that provide more
flexibility (and/or/replace).  See the Calculations vignette for details.}

\item{\code{format}}{A character, list or custom function to format the calculation
result.}

\item{\code{fmtFuncArgs}}{A list that specifies any additional arguments to pass to
a custom format function.}

\item{\code{dataName}}{Specifies which data frame in the pivot table is used for
this calculation (as specified in `pt$addData()`).}

\item{\code{type}}{The calculation type:  "summary", "calculation", "function" or
"value".}

\item{\code{valueName}}{For type="value", the name of the column containing the
value to display in the pivot table.}

\item{\code{summariseExpression}}{For type="summary", either the dplyr expression to
use with dplyr::summarise() or a data.table calculation expression.}

\item{\code{calculationExpression}}{For type="calculation", an expression to combine
aggregate values.}

\item{\code{calculationFunction}}{For type="function", a reference to a custom R
function that will carry out the calculation.}

\item{\code{calcFuncArgs}}{For type="function", a list that specifies additional
arguments to pass to calculationFunction.}

\item{\code{basedOn}}{A character vector specifying the names of one or more
calculations that this calculation depends on.}

\item{\code{noDataValue}}{An integer or numeric value specifying the value to use if
no data exists for a particular cell.}

\item{\code{noDataCaption}}{A character value that will be displayed by the pivot
table if no  data exists for a particular cell.}

\item{\code{headingBaseStyleName}}{The name of a style defined in the pivot table
to use as the base styling for the data group heading.}

\item{\code{headingStyleDeclarations}}{A list of CSS style declarations (e.g.
`list("font-weight"="bold")`) to override the base style.}

\item{\code{cellBaseStyleName}}{The name of a style defined in the pivot table to
use as the base styling for the cells related to this calculation.}

\item{\code{cellStyleDeclarations}}{A list of CSS style declarations (e.g.
`list("font-weight"="bold")`) to override the base style.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `PivotCalculation` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotCalculationGroup-asList"></a>}}
\if{latex}{\out{\hypertarget{method-PivotCalculationGroup-asList}{}}}
\subsection{Method \code{asList()}}{
Return the contents of this object as a list for debugging.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotCalculationGroup$asList()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of various object properties.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotCalculationGroup-asJSON"></a>}}
\if{latex}{\out{\hypertarget{method-PivotCalculationGroup-asJSON}{}}}
\subsection{Method \code{asJSON()}}{
Return the contents of this object as JSON for debugging.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotCalculationGroup$asJSON()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A JSON representation of various object properties.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotCalculationGroup-asString"></a>}}
\if{latex}{\out{\hypertarget{method-PivotCalculationGroup-asString}{}}}
\subsection{Method \code{asString()}}{
Return a representation of this object as a character value.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotCalculationGroup$asString(seperator = ", ")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{seperator}}{A character value used when concatenating
the text representations of different calculations.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character summary of various object properties.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotCalculationGroup-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PivotCalculationGroup-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotCalculationGroup$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
