#' get_app_detail fetching details about an app
#'
#' @param token login token generated by \code{\link{get_login_token}}
#' @param app app id, see \code{\link{get_apps_list}}
#'
#' @return data.frame with details about the app
#' @export

get_app_detail <- function(token, app) {

  get_single <- function(token) {

    url <- paste0(token$url, glue::glue("/api/apps/v2/{app}"))

    result <- httr::GET(
      url = url,
      httr::add_headers(Authorization = paste0(token$token_type, " ",
                                               token$access_token)),
      httr::add_headers("Accept-Encoding" = "gzip, deflate"),
      httr::content_type("application/vnd.api+json")
    )

    if (httr::status_code(result) == 200) {
      json <- httr::content(result, "text", encoding = "utf8")

      from_json <- json %>% rjson::fromJSON(simplify = FALSE)
      data <- from_json %>% extract2("data")
      app_attributes <- data %>% extract2("attributes") %>%
        purrr::imap_dfc(~ tibble({{.y}} := ifelse(length(.x) > 1, list(.x), .x)))

      return_value = tibble(type = data$type, id = data$id) %>%
        dplyr::bind_cols(app_attributes)

      return(list("data" = return_value))
    } else {
      warning(httr::content(result, "text", encoding = "utf8")%>% rjson::fromJSON(simplify = FALSE))
      return(NULL)
    }
  }

  result <- get_single(token)
  result_data <- result$data


  return(result_data)
}
