% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pix_keys.R
\name{get_pix_keys_summary}
\alias{get_pix_keys_summary}
\title{Get PIX Keys Summary by Institution}
\usage{
get_pix_keys_summary(date, n_top = 20, verbose = TRUE)
}
\arguments{
\item{date}{Character string in "YYYY-MM-DD" format specifying the reference
date. This parameter is \strong{required}. The API returns data for the last
day of the specified month.}

\item{n_top}{Integer; number of top institutions to return. Default is 20.}

\item{verbose}{Logical; if TRUE (default), prints progress messages.}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with summary data by institution.
}
\description{
Retrieves PIX keys data and returns a summary showing total keys by
institution, sorted by total keys.
}
\examples{
\donttest{# It usually takes much longer than 5 seconds.
# Get top 20 institutions by total keys
get_pix_keys_summary(date = "2025-12-01")

# Get top 10 institutions
get_pix_keys_summary(date = "2025-12-01", n_top = 10)
}
}
