% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compile.R
\name{compile_model}
\alias{compile_model}
\title{Model Compiler}
\usage{
compile_model(
  mName,
  application = "mcsim",
  use_model_file = TRUE,
  mcsim_dir = NULL,
  mod_dir = NULL
)
}
\arguments{
\item{mName}{a string giving the name of the model code (without extension).}

\item{application}{a character to assign the specific methods (\code{mcsim} or \code{R})
that will be applied to the numerical analysis (default is \code{mcsim}).
The version must be assigned for Windows user (default is \code{6.2.0}).}

\item{use_model_file}{a logical value to operate the compiler to model or C file,
the default is set to \code{TRUE} to assign the \pkg{GNU MCSim}'s model file in compiling.}

\item{mcsim_dir}{a character to assign the installed location of MCSim directory
(The default is set to home).}

\item{mod_dir}{a character giving the name of the directory that is used to store the model file.}
}
\value{
The default \code{application} is set to \code{'mcsim'}
to generate the executable program to solve differential equations by \pkg{GNU MCSim}.
If \code{application = 'R'},
the function will compile and create dynamic-link libraries (.dll) on Windows and
shared objects (.so) on Unix-likes systems (e.g., Linux and MacOS) that can link with \pkg{deSolve} solver.
}
\description{
The \code{compile_model} is used to compile the model code that is written under C or \pkg{GNU MCSim} format and
generate the executable program in numerical analysis.
}
\details{
Generally, the solving function through \pkg{GNU MCSim} can provide faster computing speed than exporting C in R.
Therefore, this function set \code{use_model_file = TRUE} and \code{application = 'mcsim'}
as a default setting, suggesting to use \pkg{GNU MCSim} as main solver to solve the differential equation.
To compile model code in Windows, be sure to install Rtools (rtools40) first.
In addition, the \code{version} of \pkg{GNU MCSim} should provide to conduct model compiling in Windows.
}
