% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poker.R
\name{play_poker}
\alias{play_poker}
\alias{poker}
\title{Play five-card draw poker}
\usage{
play_poker(colors = c(2, 4, 1))
}
\arguments{
\item{colors}{One of \code{1}, \code{2}, or \code{4}.
The number of colors to use to render the suits.
\itemize{
\item For \code{1}, all suits are the default console color.
\item For \code{2}, hearts and diamonds are red and spades and clubs are
the default console color.
\item For \code{4}, hearts are red, clubs are green, diamonds are blue, and spades
are the default console color.
}}
}
\value{
Generates an interactive game of poker in the console.
}
\description{
Interact with the game by typing commands into the console and
pressing enter.
}
\section{Scoring}{
\tabular{lll}{
   \strong{Hand} \tab \strong{Points} \tab \strong{Description} \cr
   Junk \tab -10 \tab Nothing of value. \cr
   Low pair \tab 0 \tab Two cards of the same rank, ten or below. \cr
   High pair \tab 5 \tab Two aces, kings, queens, or jacks. \cr
   Two pair \tab 10 \tab Two cards of one rank and two cards of another. \cr
   Three of a kind \tab 20 \tab Three cards of the same rank. \cr
   Straight \tab 50 \tab Five cards in sequential order. \cr
   Flush \tab 75 \tab Five cards of the same suit. \cr
   Full house \tab 100 \tab Three cards of one rank and two cards of another. \cr
   Four of a kind \tab 1,000 \tab Four cards of the same rank. \cr
   Straight flush \tab 50,000 \tab Five cards of the same suit in sequential order. \cr
   Royal flush \tab 1,000,000 \tab Ace, king, queen, jack, and ten of the same suit. \cr
}


For straights, aces may be considered the highest card (above king) or the
lowest card (below two).
However, aces may not be used to connect a king and a two
(e.g. Q-K-A-2-3 is not a straight).
}

\examples{
play_poker()
play_poker(colors = 4)
play_poker(colors = 1)
}
