% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_shapefile.R
\name{plot_id}
\alias{plot_id}
\title{Generate plot IDs with different layouts}
\usage{
plot_id(
  shapefile,
  nrow,
  ncol,
  layout = c("tblr", "tbrl", "btlr", "btrl", "lrtb", "lrbt", "rltb", "rlbt"),
  plot_prefix = "P",
  serpentine = FALSE
)
}
\arguments{
\item{shapefile}{An object computed with \code{\link[=shapefile_build]{shapefile_build()}}}

\item{nrow}{The number of columns}

\item{ncol}{The number of rows}

\item{layout}{Character: one of
\itemize{
\item \code{'tblr'} for top/bottom left/right orientation
\item \code{'tbrl'} for top/bottom right/left orientation
\item \code{'btlr'} for bottom/top left/right orientation
\item \code{'btrl'} for bottom/top right/left orientation
\item \code{'lrtb'} for left/right top/bottom orientation
\item \code{'lrbt'} for left/right bottom/top orientation
\item \code{'rltb'} for right/left top/bottom orientation
\item \code{'rlbt'} for right/left bottom/top orientation
}}

\item{plot_prefix}{The plot_id prefix. Defaults to \code{'P'}.}

\item{serpentine}{Create a serpentine-based layout? Defaults to \code{FALSE}.}
}
\value{
A vector of plot IDs with specified layout
}
\description{
Based on a shapefile, number of columns and rows, generate plot IDs with
different layouts.
}
