% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vec_mat_dist.R
\name{vec_mat_dist}
\alias{vec_mat_dist}
\title{Euclidean distance from a single vector to each row of a matrix}
\usage{
vec_mat_dist(v, mat)
}
\arguments{
\item{v}{Numeric vector of length \emph{d}. The reference point in \emph{d}-dimensional
space.}

\item{mat}{Numeric matrix with \emph{n} rows and \emph{d} columns. Each row is treated
as a point whose distance from \code{v} is to be computed.
The number of columns in \code{mat} must match \code{length(v)}.}
}
\value{
A numeric vector of length \emph{n} containing the Euclidean distance
between \code{v} and each corresponding row of \code{mat}.
}
\description{
Calculates the Euclidean distance between a reference vector
\code{v} and every row of a matrix \code{mat}.  This is a thin wrapper around
\code{rowSums()} and avoids an explicit loop, so it is fast even for large
matrices.
}
\details{
Internally the function replicates \code{v} into an \eqn{n \times d}{n x d} matrix, subtracts it
from \code{mat}, squares the element-wise differences, sums across columns, and
finally takes the square root, i.e.
\deqn{d_i = \sqrt{\sum_{k=1}^d (m_{ik} - v_k)^2}}
for each row \emph{i}.
Because the computation is fully vectorised it is considerably faster than a
simple \code{apply()} or a for-loop implementation.
}
\examples{
# Two-dimensional example
v   <- c(0, 0)
mat <- matrix(c(1, 0,
                0, 2,
                3, 4),
              ncol = 2, byrow = TRUE)

vec_mat_dist(v, mat)
#> [1] 1 2 5

}
