% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/default.R
\name{plotsize.default}
\alias{plotsize.default}
\title{Determine Plot Size by Default}
\usage{
\method{plotsize}{default}(x, width, height,
  digits = getOption("plotscale_plotsize_digits", 3),
  pattern = c("subpanel\\\\b", "panel\\\\b"), index = 1, ...)
}
\arguments{
\item{x}{object}

\item{width}{device width in inches}

\item{height}{device height in inches}

\item{digits}{\code{\link{round}} result to this many decimal places}

\item{pattern}{character: vector of search patterns to identify critical viewport set; first non-empty set is retained}

\item{index}{integer: select this element of the critical viewport set}

\item{...}{other arguments passed to \code{\link[grDevices]{pdf}}}
}
\value{
length 2 named list giving width and height in inches (class 'size') for the first panel
}
\description{
Determines the size of a grid graphics plot conditional on device dimensions.
Size is defined as physical width and height in inches
of the first encountered panel as rendered on a device with the
specified width and height. \code{pdf()} is used as the evaluation
device. 'First encountered panel' is resolved by evaluating the
output of a call to \code{\link[grid]{current.vpTree}} for the
first viewport name containing 'panel' or 'subpanel'. The latter
takes precedence if available, for intuitive handling of output from
\code{\link[lattice]{splom}}.
}
\examples{
options(ask.default = FALSE)
options(device.ask.default = FALSE)
library(lattice)
p <- xyplot(2~3)
plotsize(p, width = 7, height = 7)
}
\seealso{
Other plotsize: \code{\link{as.size}},
  \code{\link{plotsize}}, \code{\link{print.size}}
}
