% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.table.summary.cv.plsRmodel.R
\name{plot.table.summary.cv.plsRmodel}
\alias{plot.table.summary.cv.plsRmodel}
\title{Plot method for table of summary of cross validated plsR models}
\usage{
\method{plot}{table.summary.cv.plsRmodel}(x, type = c("CVMC", "CVQ2", "CVPress"), ...)
}
\arguments{
\item{x}{an object of the class \code{"table.summary.cv.plsRmodel"}}

\item{type}{the type of cross validation criterion to plot.}

\item{\dots}{further arguments to be passed to or from methods.}
}
\value{
\code{NULL}
}
\description{
This function provides a table method for the class
\code{"summary.cv.plsRmodel"}
}
\examples{

data(Cornell)
bbb <- cv.plsR(Y~.,data=Cornell,nt=6,K=6,NK=5, verbose=FALSE)
plot(cvtable(summary(bbb)),type="CVQ2")
rm(list=c("bbb"))

\donttest{
data(Cornell)
plot(cvtable(summary(cv.plsR(Y~.,data=Cornell,nt=6,K=6,NK=100, verbose=FALSE))),type="CVQ2")
}

}
\references{
Nicolas Meyer, Myriam Maumy-Bertrand et
Frédéric Bertrand (2010). Comparing the linear and the
logistic PLS regression with qualitative predictors: application to
allelotyping data. \emph{Journal de la Societe Francaise de Statistique},
151(2), pages 1-18.
\url{https://www.numdam.org/item/JSFS_2010__151_2_1_0/}
}
\seealso{
\code{\link{summary}}
}
\author{
Frédéric Bertrand\cr
\email{frederic.bertrand@lecnam.net}\cr
\url{https://fbertran.github.io/homepage/}
}
\keyword{methods}
\keyword{print}
