% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmrm_estimates.R
\name{pmrm_estimates}
\alias{pmrm_estimates}
\title{Parameter estimates and confidence intervals}
\usage{
pmrm_estimates(
  fit,
  parameter = c("theta", "beta", "alpha", "gamma", "sigma", "phi", "rho", "Sigma",
    "Lambda"),
  confidence = 0.95
)
}
\arguments{
\item{fit}{A fitted model object of class \code{"pmrm_fit"} returned
by a \code{pmrm} model-fitting function.}

\item{parameter}{Character string, name of the type of model
parameter to summarize. Must be one of \code{"beta"}, \code{"theta"},
\code{"alpha"}, \code{"gamma"}, \code{"sigma"}, \code{"rho"}, \code{"Sigma"}, or \code{"Lambda"}.}

\item{confidence}{Numeric between 0 and 1, the confidence level
to use in 2-sided normal confidence intervals.}
}
\value{
A \code{tibble} with one row for each scalar element of the
selected model parameter and columns with estimates,
standard errors, lower and upper bounds of two-sided
normal confidence intervals, and indexing variables.
If applicable, the indexing variables are \code{arm} and/or \code{visit}
to indicate the study arm and study visit.
If there is no obvious indexing factor in the data,
then a generic integer \code{index} column is used.
For covariance matrices, elements are identified with the
\code{visit_row} and \code{visit_column} columns.

\code{beta} is not a true parameter.
Instead, it is a function of \code{theta} and fixed at zero
for the control arm and at baseline.
At these marginals,
the standard errors and confidence intervals for \code{beta} are \code{NA_real_}.
}
\description{
Report parameter estimates and confidence intervals for
a progression model for repeated measures (PMRM).
}
\examples{
  set.seed(0L)
  simulation <- pmrm_simulate_decline_nonproportional(
    visit_times = seq_len(5L) - 1,
    gamma = c(1, 2)
  )
  fit <- pmrm_model_decline_nonproportional(
    data = simulation,
    outcome = "y",
    time = "t",
    patient = "patient",
    visit = "visit",
    arm = "arm",
    covariates = ~ w_1 + w_2
  )
  pmrm_estimates(fit, parameter = "beta")
  pmrm_estimates(fit, parameter = "alpha")
}
\concept{estimates and predictions}
