% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmseSampling-package.R
\docType{package}
\name{pmsesampling-package}
\alias{pmsesampling}
\alias{pmsesampling-package}
\title{pmsesampling: Sample Size Determination for Accurate Predictive Linear Regression}
\description{
Tools to estimate the minimum sample size required to achieve a
target Prediction Mean-Squared Error (PMSE) or a specified
proportional PMSE reduction (pPMSE\if{html}{\out{<sub>}}r\if{html}{\out{</sub>}}).  Functions implement the
analytic and simulation-based criteria described in
Ma (2023) and include helpers for covariance-matrix handling,
root-finding and diagnostic plotting.
}
\section{Core functions}{

\describe{
\item{\code{pmse_samplesize()}}{Determines sample size from PMSE equation in
basic and full models and the efficient sample size}
}
}

\section{Typical workflow}{

\enumerate{
\item Obtain \eqn{\sigma_k^2} and \eqn{\sigma_p^2}
\item Or import or build a predictor covariance matrix.\cr
\item Or obtain \eqn{Cohen's f^2} and \eqn{\R^2}
\item Call \code{pmse_samplesize} with available inputs to get sample size.\cr
}
}

\references{
Ma Y. (2023) \emph{Predictive Power and Efficient Sample Size in
Linear Regression Models}. Worchester Polytechnic Institute
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/Chenaters/pmsesampling}
  \item Report bugs at \url{https://github.com/Chenaters/pmsesampling/issues}
}

}
\author{
\strong{Maintainer}: Louis Chen \email{chenaters@gmail.com}

Authors:
\itemize{
  \item Zheyang Wu \email{zheyangwu@wpi.edu} [thesis advisor]
}

}
