% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling.R
\name{run_stage}
\alias{run_stage}
\title{Run a stage of the PMwG sampler}
\usage{
run_stage(
  pmwgs,
  stage,
  iter = 1000,
  particles = 100,
  display_progress = TRUE,
  n_cores = 1,
  n_unique = ifelse(stage == "adapt", 100, NA),
  epsilon = NULL,
  p_accept = 0.8,
  mix = NULL,
  pdist_update_n = ifelse(stage == "sample", 50, NA)
)
}
\arguments{
\item{pmwgs}{A Particle Metropolis within Gibbs sampler which has been set
up and initialised}

\item{stage}{The sampling stage to run. Must be one of \code{'burn'},
\code{'adapt'} or \code{'sample'}.}

\item{iter}{The number of iterations to run for the sampler. For
\code{'burn'} and \code{'sample'} all iterations will run. However for
\code{'adapt'} if all subjects have enough unique samples to create the
conditional distribution then the stage will finish early.}

\item{particles}{The default here is 1000 particles to be generated for each
iteration, however during the sample phase this should be reduced.}

\item{display_progress}{Display a progress bar during sampling.}

\item{n_cores}{Set to more than 1 to use \code{mclapply}. Setting
\code{n_cores} greater than 1 is only permitted on Linux and Mac OS X
machines.}

\item{n_unique}{A number representing the number of unique samples to check
for on each iteration of the sampler (An initial test for the generation
of the proposal distribution). Only used during the \code{'adapt'} stage.}

\item{epsilon}{A value between 0 and 1 that controls the extent to which the
covariance matrix is scaled when generating particles from the previous
random effect. The default will be chosen based on the number of random
effects in the model.}

\item{p_accept}{A value between 0 and 1 that will flexibly tune epsilon to
achieve an acceptance ratio close to what you set p_accept to. The default
is set at 0.8.}

\item{mix}{A vector of floats that controls the mixture of different sources
for particles. The function \code{\link{numbers_from_proportion}} is
passed this value and includes extra details on what is accepted.}

\item{pdist_update_n}{The number of iterations in the sample stage after
which the proposal distribution will be recomputed.}
}
\value{
A pmwgs object with the newly generated samples in place.
}
\description{
Run one of burnin, adaptation or sampling phase from the PMwG
sampler. Each stage involves slightly different processes, so for the
full PMwG sampling we need to run this three times.
}
\details{
The \strong{burnin} stage by default selects 50% of particles from the model
parameter sample (selected through a Gibbs step) and 50% of particles from
the previous random effect of each subject. It assesses each particle with
the log-likelihood function and samples from all particles weighted by their
log-likelihood.

The \strong{adaptation} stage selects and assesses particle in the same was
as burnin, however on each iteration it also checks whether each subject has
enough unique random effect samples to attempt to create a conditional
distribution for efficient sampling in the next stage. If the attempt at
creating a conditional distribution fails, then the number of unique samples
is increased and sampling continues. If the attempt succeeds then the stage
is finished early.

The \strong{final} stage (sampling) by default samples predominantly from the
conditional distribution created at the end of adaptation. This is more
efficient and allows the number of particles to be reduced whilst still
getting a high enough acceptance rate of new samples.

Once complete each stage will return a sampler object with the new samples
stored within it.

The progress bar (which is displayed by default) shows the number of
iterations out of those requested which have been completed. It also contains
additional information at the end about the number of newly generated
particles that have been accepted. This is show as New(XXX%), and is the
average across subjects of newly sampled random effects accept rate. See
\code{\link{accept_rate}} for more detail on getting individual accept rate
values per subject.
}
\examples{
library(rtdists)
sampled_forstmann$data <- forstmann
run_stage(sampled_forstmann, "sample", iter = 1, particles = 10)
}
