% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/der_vs_state.R
\name{ind_der_state_plot_nm}
\alias{ind_der_state_plot_nm}
\title{Generate Derivative versus State Plot for individual parameter estimates (NONMEM)}
\usage{
ind_der_state_plot_nm(
  nn_name,
  min_state = NULL,
  max_state = NULL,
  inputs = NULL,
  est_parms = NULL,
  nm_res_file = NULL,
  nm_phi_file = NULL,
  length_out = 100,
  time_nn = FALSE,
  ribbon = TRUE,
  act = "ReLU",
  beta = 20,
  transform = NULL
)
}
\arguments{
\item{nn_name}{(string) Name of the NN, e.g., \dQuote{c} for NNc(...)}

\item{min_state}{(numeric) Value of minimal state for which the derivative should be calculated (optional if inputs is given, ignored if inputs is defined)}

\item{max_state}{(numeric) Value of maximal state for which the derivative should be calculated (optional if inputs is given, ignored if inputs is defined)}

\item{inputs}{(numeric vector) Vector of input values for which derivatives should be calculated (optional if min_state and max_state is given)}

\item{est_parms}{(named vector; semi-optional) A data frame with estimated individual parameters from the NN 
extracted through the \emph{indparm_extractor_nm} function. For optionality, see \strong{Details}.}

\item{nm_res_file}{(string; semi-optional) (path)/name of the results file of a NONMEM run, must include file extension, e.g., “.res”. For optionality, see \strong{Details}.}

\item{nm_phi_file}{(string; semi-optional) (path)/name of the phi file of a NONMEM run, must include file extension “.phi”. For optionality, see \strong{Details}.}

\item{length_out}{(numeric) Number of points between min_state and max_state}

\item{time_nn}{(boolean) Whether the neural network to analyze is a time-dependent neural network or not. Default values is FALSE.}

\item{ribbon}{(boolean) Whether individual derivatives versus states should be summarise in a ribbon (TRUE) or
displayed as individual spaghetti plot (FALSE)}

\item{act}{(string) Activation function used in the NN. Currently "ReLU" and "Softplus" available.}

\item{beta}{(numeric) Beta value for the Softplus activation function, only applicable if \emph{act="Softplus"}; Default to 20.}

\item{transform}{(string) Mathematical exression as string to transform the NN output. Independent variable must be called NN, e.g.,
"1/(1+exp(-NN))" for sigmoidal transformation.}
}
\value{
Displaying derivative versus state plot
}
\description{
This functions allows to generate a derivative versus state plot for a neural network from a NODE in NONMEM
with individual parameter estimates (EBEs).
}
\details{
Either \emph{est_parms} or \emph{nm_res_file} and \emph{nm_phi_file} must be given. If both arguments are given, \emph{est_parms} is prioritized.
}
\examples{
res_path <- system.file("extdata","nm_example1_model_converted_ind.res",package="pmxNODE")
phi_path <- system.file("extdata","nm_example1_model_converted_ind.phi",package="pmxNODE")
der_state_plot <- ind_der_state_plot_nm(nn="c",min_state=0,max_state=10,
                                        nm_res_file=res_path,
                                        nm_phi_file=phi_path)
}
\author{
Dominic Bräm
}
