% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn_parmsetter_nm.R
\name{nn_eta_initializer_nm}
\alias{nn_eta_initializer_nm}
\title{Internal: Set initial ETA estimates in NONMEM}
\usage{
nn_eta_initializer_nm(
  number,
  theta_inis,
  pop = FALSE,
  n_hidden = 5,
  eta_scale = 0.1,
  time_nn = FALSE
)
}
\arguments{
\item{number}{(string) Name of the NN, e.g., \dQuote{1} for NN1(...)}

\item{theta_inis}{(list of string) THETA initial values generated in \emph{nn_theta_initializer_nm}}

\item{pop}{(boolean) Whether population fit without inter-individual variability is performed (TRUE)
or whether model is fitted with inter-individual variability (FALSE)}

\item{n_hidden}{(numeric) Number of neurons in the hidden layer, default value is 5}

\item{eta_scale}{(numeric) Initial standard deviation of random effects, default value is 0.1}

\item{time_nn}{(boolean) Whether the neural network to analyze is a time-dependent neural network or not. Default values is FALSE.}
}
\value{
Vector of initial NN parameter ETA values for one specific NN
}
\description{
Set the initial ETA estimates for the $OMEGA block in the NONMEM model file
}
\details{
ETAs are fixed to 0 if \cr
\itemize{
  \item population fit is enabled through \emph{pop=TRUE}, all ETAs are fixed to 0
  \item the corresponding THETA is fixed to 0 due to non-activity of the neuron
}
}
\author{
Dominic Bräm
}
\keyword{internal}
