% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{dupRowInds}
\alias{dupRowInds}
\title{Repeated indices of the first unique value}
\usage{
dupRowInds(m)
}
\arguments{
\item{m}{A matrix or a data frame.

This function is an inverse function to such operations as
\code{m[c(1:3, 1, 1, 2), ]}: the matrix with potentially duplicated rows is
taken as input, and repeated indices of the first occurrence of each row
are returned.

This function is faster -- at least in the examples tested so far -- than
\code{match(data.frame(t(m)), data.frame(t(unique(m))))}.}
}
\value{
A vector of row indices corresponding to the first ocurrence of a given row.
}
\description{
Repeated indices of the first unique value
}
\examples{
dupRowInds(mtcars[rep(1:10, 10), rep(1:10, 10)])
dupRowInds(matrix(rnorm(1000), ncol = 10))
}
