% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/col_exists.R
\name{col_exists}
\alias{col_exists}
\alias{expect_col_exists}
\alias{test_col_exists}
\title{Do one or more columns actually exist?}
\usage{
col_exists(
  x,
  columns = NULL,
  actions = NULL,
  step_id = NULL,
  label = NULL,
  brief = NULL,
  active = TRUE
)

expect_col_exists(object, columns, threshold = 1)

test_col_exists(object, columns, threshold = 1)
}
\arguments{
\item{x}{\emph{A pointblank agent or a data table}

\verb{obj:<ptblank_agent>|obj:<tbl_*>} // \strong{required}

A data frame, tibble (\code{tbl_df} or \code{tbl_dbi}), Spark DataFrame
(\code{tbl_spark}), or, an \emph{agent} object of class \code{ptblank_agent} that is
commonly created with \code{\link[=create_agent]{create_agent()}}.}

\item{columns}{\emph{The target columns}

\verb{<tidy-select>} // \strong{required}

A column-selecting expression, as one would use inside \code{dplyr::select()}.
Specifies the column (or a set of columns) to which this validation should
be applied. See the \emph{Column Names} section for more information.}

\item{actions}{\emph{Thresholds and actions for different states}

\verb{obj:<action_levels>} // \emph{default:} \code{NULL} (\code{optional})

A list containing threshold levels so that the validation step can react
accordingly when exceeding the set levels for different states. This is to
be created with the \code{\link[=action_levels]{action_levels()}} helper function.}

\item{step_id}{\emph{Manual setting of the step ID value}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

One or more optional identifiers for the single or multiple validation
steps generated from calling a validation function. The use of step IDs
serves to distinguish validation steps from each other and provide an
opportunity for supplying a more meaningful label compared to the step
index. By default this is \code{NULL}, and \strong{pointblank} will automatically
generate the step ID value (based on the step index) in this case. One or
more values can be provided, and the exact number of ID values should (1)
match the number of validation steps that the validation function call will
produce (influenced by the number of \code{columns} provided), (2) be an ID
string not used in any previous validation step, and (3) be a vector with
unique values.}

\item{label}{\emph{Optional label for the validation step}

\verb{vector<character>} // \emph{default:} \code{NULL} (\code{optional})

Optional label for the validation step. This label appears in the \emph{agent}
report and, for the best appearance, it should be kept quite short. See
the \emph{Labels} section for more information.}

\item{brief}{\emph{Brief description for the validation step}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

A \emph{brief} is a short, text-based description for the validation step. If
nothing is provided here then an \emph{autobrief} is generated by the \emph{agent},
using the language provided in \code{\link[=create_agent]{create_agent()}}'s \code{lang} argument (which
defaults to \code{"en"} or English). The \emph{autobrief} incorporates details of the
validation step so it's often the preferred option in most cases (where a
\code{label} might be better suited to succinctly describe the validation).}

\item{active}{\emph{Is the validation step active?}

\verb{scalar<logical>} // \emph{default:} \code{TRUE}

A logical value indicating whether the validation step should be active. If
the validation function is working with an \emph{agent}, \code{FALSE} will make the
validation step inactive (still reporting its presence and keeping indexes
for the steps unchanged). If the validation function will be operating
directly on data (no \emph{agent} involvement), then any step with \code{active = FALSE} will simply pass the data through with no validation whatsoever.
Aside from a logical vector, a one-sided R formula using a leading \code{~} can
be used with \code{.} (serving as the input data table) to evaluate to a single
logical value. With this approach, the \strong{pointblank} function
\code{\link[=has_columns]{has_columns()}} can be used to determine whether to make a validation step
active on the basis of one or more columns existing in the table
(e.g., \code{~ . \%>\% has_columns(c(d, e))}).}

\item{object}{\emph{A data table for expectations or tests}

\verb{obj:<tbl_*>} // \strong{required}

A data frame, tibble (\code{tbl_df} or \code{tbl_dbi}), or Spark DataFrame
(\code{tbl_spark}) that serves as the target table for the expectation function
or the test function.}

\item{threshold}{\emph{The failure threshold}

\code{scalar<integer|numeric>(val>=0)} // \emph{default:} \code{1}

A simple failure threshold value for use with the expectation (\code{expect_})
and the test (\code{test_}) function variants. By default, this is set to \code{1}
meaning that any single unit of failure in data validation results in an
overall test failure. Whole numbers beyond \code{1} indicate that any failing
units up to that absolute threshold value will result in a succeeding
\strong{testthat} test or evaluate to \code{TRUE}. Likewise, fractional values
(between \code{0} and \code{1}) act as a proportional failure threshold, where \code{0.15}
means that 15 percent of failing test units results in an overall test
failure.}
}
\value{
For the validation function, the return value is either a
\code{ptblank_agent} object or a table object (depending on whether an agent
object or a table was passed to \code{x}). The expectation function invisibly
returns its input but, in the context of testing data, the function is
called primarily for its potential side-effects (e.g., signaling failure).
The test function returns a logical value.
}
\description{
The \code{col_exists()} validation function, the \code{expect_col_exists()} expectation
function, and the \code{test_col_exists()} test function all check whether one or
more columns exist in the target table. The only requirement is specification
of the column names. The validation function can be used directly on a data
table or with an \emph{agent} object (technically, a \code{ptblank_agent} object)
whereas the expectation and test functions can only be used with a data
table. Each validation step or expectation will operate over a single test
unit, which is whether the column exists or not.
}
\section{Supported Input Tables}{


The types of data tables that are officially supported are:
\itemize{
\item data frames (\code{data.frame}) and tibbles (\code{tbl_df})
\item Spark DataFrames (\code{tbl_spark})
\item the following database tables (\code{tbl_dbi}):
\itemize{
\item \emph{PostgreSQL} tables (using the \code{RPostgres::Postgres()} as driver)
\item \emph{MySQL} tables (with \code{RMySQL::MySQL()})
\item \emph{Microsoft SQL Server} tables (via \strong{odbc})
\item \emph{BigQuery} tables (using \code{bigrquery::bigquery()})
\item \emph{DuckDB} tables (through \code{duckdb::duckdb()})
\item \emph{SQLite} (with \code{RSQLite::SQLite()})
}
}

Other database tables may work to varying degrees but they haven't been
formally tested (so be mindful of this when using unsupported backends with
\strong{pointblank}).
}

\section{Column Names}{


\code{columns} may be a single column (as symbol \code{a} or string \code{"a"}) or a vector
of columns (\code{c(a, b, c)} or \code{c("a", "b", "c")}). \code{{tidyselect}} helpers
are also supported, such as \code{contains("date")} and \code{where(is.double)}. If
passing an \emph{external vector} of columns, it should be wrapped in \code{all_of()}.

When multiple columns are selected by \code{columns}, the result will be an
expansion of validation steps to that number of columns (e.g.,
\code{c(col_a, col_b)} will result in the entry of two validation steps).

Previously, columns could be specified in \code{vars()}. This continues to work,
but \code{c()} offers the same capability and supersedes \code{vars()} in \code{columns}.
}

\section{Actions}{


Often, we will want to specify \code{actions} for the validation. This argument,
present in every validation function, takes a specially-crafted list object
that is best produced by the \code{\link[=action_levels]{action_levels()}} function. Read that function's
documentation for the lowdown on how to create reactions to above-threshold
failure levels in validation. The basic gist is that you'll want at least a
single threshold level (specified as either the fraction of test units
failed, or, an absolute value), often using the \code{warn_at} argument. Using
\code{action_levels(warn_at = 1)} or \code{action_levels(stop_at = 1)} are good choices
depending on the situation (the first produces a warning, the other
\code{stop()}s).
}

\section{Labels}{


\code{label} may be a single string or a character vector that matches the number
of expanded steps. \code{label} also supports \code{{glue}} syntax and exposes the
following dynamic variables contextualized to the current step:
\itemize{
\item \code{"{.step}"}: The validation step name
\item \code{"{.col}"}: The current column name
}

The glue context also supports ordinary expressions for further flexibility
(e.g., \code{"{toupper(.step)}"}) as long as they return a length-1 string.
}

\section{Briefs}{


Want to describe this validation step in some detail? Keep in mind that this
is only useful if \code{x} is an \emph{agent}. If that's the case, \code{brief} the agent
with some text that fits. Don't worry if you don't want to do it. The
\emph{autobrief} protocol is kicked in when \code{brief = NULL} and a simple brief will
then be automatically generated.
}

\section{YAML}{


A \strong{pointblank} agent can be written to YAML with \code{\link[=yaml_write]{yaml_write()}} and the
resulting YAML can be used to regenerate an agent (with \code{\link[=yaml_read_agent]{yaml_read_agent()}})
or interrogate the target table (via \code{\link[=yaml_agent_interrogate]{yaml_agent_interrogate()}}). When
\code{col_exists()} is represented in YAML (under the top-level \code{steps} key as a
list member), the syntax closely follows the signature of the validation
function. Here is an example of how a complex call of \code{col_exists()} as a
validation step is expressed in R code and in the corresponding YAML
representation.

R statement:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{agent \%>\%
  col_exists(
    columns = a,
    actions = action_levels(warn_at = 0.1, stop_at = 0.2),
    label = "The `col_exists()` step.",
    active = FALSE
  )
}\if{html}{\out{</div>}}

YAML representation:

\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{steps:
- col_exists:
    columns: c(a)
    actions:
      warn_fraction: 0.1
      stop_fraction: 0.2
    label: The `col_exists()` step.
    active: false
}\if{html}{\out{</div>}}

In practice, both of these will often be shorter as only the \code{columns}
argument requires a value. Arguments with default values won't be written to
YAML when using \code{\link[=yaml_write]{yaml_write()}} (though it is acceptable to include them with
their default when generating the YAML by other means). It is also possible
to preview the transformation of an agent to YAML without any writing to disk
by using the \code{\link[=yaml_agent_string]{yaml_agent_string()}} function.
}

\section{Examples}{


For all examples here, we'll use a simple table with two columns: \code{a} and
\code{b}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tbl <-
  dplyr::tibble(
    a = c(5, 7, 6, 5, 8, 7),
    b = c(7, 1, 0, 0, 0, 3)
  )

tbl
#> # A tibble: 6 x 2
#>       a     b
#>   <dbl> <dbl>
#> 1     5     7
#> 2     7     1
#> 3     6     0
#> 4     5     0
#> 5     8     0
#> 6     7     3
}\if{html}{\out{</div>}}

We'll use this table with the different function variants.
\subsection{A: Using an \code{agent} with validation functions and then \code{interrogate()}}{

Validate that column \code{a} exists in the \code{tbl} table with \code{col_exists()}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{agent <-
  create_agent(tbl = tbl) \%>\%
  col_exists(columns = a) \%>\%
  interrogate()
}\if{html}{\out{</div>}}

Printing the \code{agent} in the console shows the validation report in the
Viewer. Here is an excerpt of validation report, showing the single entry
that corresponds to the validation step demonstrated here.

\if{html}{
\out{
<img src="https://raw.githubusercontent.com/rstudio/pointblank/main/images/man_col_exists_1.png" alt="This image was generated from the first code example in the `col_exists()` help file." style="width:100\%;">
}
}
}

\subsection{B: Using the validation function directly on the data (no \code{agent})}{

This way of using validation functions acts as a data filter. Data is
passed through but should \code{stop()} if there is a single test unit failing.
The behavior of side effects can be customized with the \code{actions} option.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tbl \%>\% col_exists(columns = a)
#> # A tibble: 6 x 2
#>       a     b
#>   <dbl> <dbl>
#> 1     5     7
#> 2     7     1
#> 3     6     0
#> 4     5     0
#> 5     8     0
#> 6     7     3
}\if{html}{\out{</div>}}
}

\subsection{C: Using the expectation function}{

With the \verb{expect_*()} form, we would typically perform one validation at a
time. This is primarily used in \strong{testthat} tests.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{expect_col_exists(tbl, columns = a)
}\if{html}{\out{</div>}}
}

\subsection{D: Using the test function}{

With the \verb{test_*()} form, we should get a single logical value returned to
us.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tbl \%>\% test_col_exists(columns = a)
#> [1] TRUE
}\if{html}{\out{</div>}}
}
}

\section{Function ID}{

2-29
}

\seealso{
Other validation functions: 
\code{\link{col_count_match}()},
\code{\link{col_is_character}()},
\code{\link{col_is_date}()},
\code{\link{col_is_factor}()},
\code{\link{col_is_integer}()},
\code{\link{col_is_logical}()},
\code{\link{col_is_numeric}()},
\code{\link{col_is_posix}()},
\code{\link{col_schema_match}()},
\code{\link{col_vals_between}()},
\code{\link{col_vals_decreasing}()},
\code{\link{col_vals_equal}()},
\code{\link{col_vals_expr}()},
\code{\link{col_vals_gt}()},
\code{\link{col_vals_gte}()},
\code{\link{col_vals_in_set}()},
\code{\link{col_vals_increasing}()},
\code{\link{col_vals_lt}()},
\code{\link{col_vals_lte}()},
\code{\link{col_vals_make_set}()},
\code{\link{col_vals_make_subset}()},
\code{\link{col_vals_not_between}()},
\code{\link{col_vals_not_equal}()},
\code{\link{col_vals_not_in_set}()},
\code{\link{col_vals_not_null}()},
\code{\link{col_vals_null}()},
\code{\link{col_vals_regex}()},
\code{\link{col_vals_within_spec}()},
\code{\link{conjointly}()},
\code{\link{row_count_match}()},
\code{\link{rows_complete}()},
\code{\link{rows_distinct}()},
\code{\link{serially}()},
\code{\link{specially}()},
\code{\link{tbl_match}()}
}
\concept{validation functions}
