% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info_add.R
\name{info_snippet}
\alias{info_snippet}
\title{Generate a useful text 'snippet' from the target table}
\usage{
info_snippet(x, snippet_name, fn)
}
\arguments{
\item{x}{\emph{The pointblank informant object}

\verb{obj:<ptblank_informant>} // \strong{required}

A \strong{pointblank} \emph{informant} object that is commonly created through the
use of the \code{\link[=create_informant]{create_informant()}} function.}

\item{snippet_name}{\emph{The snippet name}

\verb{scalar<character>} // \strong{required}

The name for snippet, which is used for interpolating the result of the
snippet formula into \emph{info text} defined by an \verb{info_*()} function.}

\item{fn}{\emph{Function for snippet text generation}

\verb{<function>} // \strong{required}

A formula that obtains a snippet of data from the target table. It's best
to use a leading dot (\code{.}) that stands for the table itself and use pipes
to construct a series of operations to be performed on the table (e.g.,
\code{~ . \%>\% dplyr::pull(column_2) \%>\% max(na.rm = TRUE)}). So long as the
result is a length-1 vector, it'll likely be valid for insertion into some
info text. Alternatively, a \verb{snip_*()} function can be used here (these
functions always return a formula that's suitable for all types of data
sources).}
}
\value{
A \code{ptblank_informant} object.
}
\description{
Getting little snippets of information from a table goes hand-in-hand with
mixing those bits of info with your table info. Call \code{info_snippet()} to
define a snippet and how you'll get that from the target table. The snippet
definition is supplied either with a formula, or, with a
\strong{pointblank}-supplied \verb{snip_*()} function. So long as you know how to
interact with a table and extract information, you can easily define snippets
for a \emph{informant} object. And once those snippets are defined, you can insert
them into the \emph{info text} as defined through the other \verb{info_*()} functions
(\code{\link[=info_tabular]{info_tabular()}}, \code{\link[=info_columns]{info_columns()}}, and \code{\link[=info_section]{info_section()}}). Use curly braces
with just the \code{snippet_name} inside (e.g., \code{"This column has {n_cat} categories."}).
}
\section{Snip functions provided in \strong{pointblank}}{


For convenience, there are several \verb{snip_*()} functions provided in the
package that work on column data from the \emph{informant}'s target table. These
are:
\itemize{
\item \code{\link[=snip_list]{snip_list()}}: get a list of column categories
\item \code{\link[=snip_stats]{snip_stats()}}: get an inline statistical summary
\item \code{\link[=snip_lowest]{snip_lowest()}}: get the lowest value from a column
\item \code{\link[=snip_highest]{snip_highest()}} : get the highest value from a column
}

As it's understood what the target table is, only the \code{column} in each of
these functions is necessary for obtaining the resultant text.
}

\section{YAML}{


A \strong{pointblank} informant can be written to YAML with \code{\link[=yaml_write]{yaml_write()}} and the
resulting YAML can be used to regenerate an informant (with
\code{\link[=yaml_read_informant]{yaml_read_informant()}}) or perform the 'incorporate' action using the target
table (via \code{\link[=yaml_informant_incorporate]{yaml_informant_incorporate()}}). Snippets are stored in the YAML
representation and here is is how they are expressed in both R code and in
the YAML output (showing both the \code{meta_snippets} and \code{columns} keys to
demonstrate their relationship here).

\if{html}{\out{<div class="sourceCode">}}\preformatted{# R statement
informant \%>\%
  info_columns(
    columns = date_time,
    `Latest Date` = "The latest date is \{latest_date\}."
  ) \%>\%
  info_snippet(
    snippet_name = "latest_date",
    fn = ~ . \%>\% dplyr::pull(date) \%>\% max(na.rm = TRUE)
  ) \%>\%
  incorporate()

# YAML representation
meta_snippets:
  latest_date: ~. \%>\% dplyr::pull(date) \%>\% max(na.rm = TRUE)
...
columns:
  date_time:
    _type: POSIXct, POSIXt
    Latest Date: The latest date is \{latest_date\}.
  date:
    _type: Date
  item_count:
    _type: integer
}\if{html}{\out{</div>}}
}

\section{Examples}{


Take the \code{small_table} dataset included in \strong{pointblank} and assign it to
\code{test_table}. We'll modify it later.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{test_table <- small_table
}\if{html}{\out{</div>}}

Generate an informant object, add two snippets with \code{info_snippet()},
add information with some other \verb{info_*()} functions and then \code{\link[=incorporate]{incorporate()}}
the snippets into the info text. The first snippet will be made with the
expression \code{~ . \%>\% nrow()} (giving us the number of rows in the dataset) and
the second uses the \code{\link[=snip_highest]{snip_highest()}} function with column \code{a} (giving us
the highest value in that column).

\if{html}{\out{<div class="sourceCode r">}}\preformatted{informant <-
  create_informant(
    tbl = ~ test_table,
    tbl_name = "test_table",
    label = "An example."
  ) \%>\%
  info_snippet(
    snippet_name = "row_count",
    fn = ~ . \%>\% nrow()
  ) \%>\%
  info_snippet(
    snippet_name = "max_a",
    fn = snip_highest(column = "a")
  ) \%>\%
  info_columns(
    columns = a,
    info = "In the range of 1 to \{max_a\}. ((SIMPLE))"
  ) \%>\%
  info_columns(
    columns = starts_with("date"),
    info = "Time-based values (e.g., `Sys.time()`)."
  ) \%>\%
  info_columns(
    columns = date,
    info = "The date part of `date_time`. ((CALC))"
  ) \%>\%
  info_section(
    section_name = "rows",
    row_count = "There are \{row_count\} rows available."
  ) \%>\%
  incorporate()
}\if{html}{\out{</div>}}

We can print the \code{informant} object to see the information report.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{informant
}\if{html}{\out{</div>}}

\if{html}{
\out{
<img src="https://raw.githubusercontent.com/rstudio/pointblank/main/images/man_info_snippet_1.png" alt="This image was generated from the first code example in the `info_snippet()` help file." style="width:100\%;">
}
}

Let's modify \code{test_table} with some \strong{dplyr} to give it more rows and an
extra column.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{test_table <-
  dplyr::bind_rows(test_table, test_table) \%>\%
  dplyr::mutate(h = a + c)
}\if{html}{\out{</div>}}

Using \code{\link[=incorporate]{incorporate()}} on the \code{informant} object will cause the snippets to be
reprocessed, and, the info text to be updated.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{informant <- informant \%>\% incorporate()

informant
}\if{html}{\out{</div>}}

\if{html}{
\out{
<img src="https://raw.githubusercontent.com/rstudio/pointblank/main/images/man_info_snippet_2.png" alt="This image was generated from the second code example in the `info_snippet()` help file." style="width:100\%;">
}
}
}

\section{Function ID}{

3-5
}

\seealso{
Other Information Functions: 
\code{\link{info_columns}()},
\code{\link{info_columns_from_tbl}()},
\code{\link{info_section}()},
\code{\link{info_tabular}()},
\code{\link{snip_highest}()},
\code{\link{snip_list}()},
\code{\link{snip_lowest}()},
\code{\link{snip_stats}()}
}
\concept{Information Functions}
