% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tooltips.R
\name{tooltips-method}
\alias{tooltips-method}
\alias{tooltips}
\alias{tooltips,character-method}
\alias{tooltips,html-method}
\alias{tooltips,kwic-method}
\title{Add tooltips to text output.}
\usage{
tooltips(.Object, tooltips, ...)

\S4method{tooltips}{character}(
  .Object,
  tooltips = list(),
  fmt = "//span[@style=\\"background-color:\%s\\"]",
  verbose
)

\S4method{tooltips}{html}(.Object, tooltips = list(), fmt, verbose = TRUE)

\S4method{tooltips}{kwic}(.Object, tooltips, regex = FALSE, ...)
}
\arguments{
\item{.Object}{A \code{html} or \code{character} object with html.}

\item{tooltips}{A named \code{list} of character vectors, the names need to
match colors in the list provided to param \code{highlight}. The value of
the character vector is the tooltip to be displayed.}

\item{...}{Further arguments are interpreted as assignments of tooltips to
tokens.}

\item{fmt}{A format string with an xpath expression used to look up the node
where the tooltip is inserted. If missing, a heuristic evaluating the names
of the \code{tooltips} list decides whether tooltips are inserted based on
highlighting colors or corpus positions.}

\item{verbose}{A \code{logical} value, whether to show messages.}

\item{regex}{A \code{logical} value, whether character vector values of argument
\code{tooltips} are interpreted as regular expressions.}
}
\description{
Highlight tokens based on exact match, a regular expression or corpus
position in \code{kwic} output or html document.
}
\examples{
use(pkg = "RcppCWB", corpus = "REUTERS")

a <- partition("REUTERS", places = "argentina")
b <- html(a)
c <- highlight(b, lightgreen = "higher")
d <- tooltips(c, list(lightgreen = "Further information"))
if (interactive()) d

# Using the tooltips-method in a pipe ...
h <- a \%>\%
  html() \%>\%
  highlight(yellow = c("barrels", "oil", "gas")) \%>\%
  tooltips(list(yellow = "energy"))
}
