% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_structure.R
\name{tree_structure}
\alias{tree_structure}
\alias{tree_structure,xml_node-method}
\alias{tree_structure,xml_document-method}
\alias{tree_structure,subcorpus-method}
\alias{tree_structure,corpus-method}
\title{Show the structure of s-attributes}
\usage{
tree_structure(x, ...)

\S4method{tree_structure}{xml_node}(x, s_attribute = NULL, prefix = 0, indent = 3, root = TRUE)

\S4method{tree_structure}{xml_document}(x, s_attribute = NULL, prefix = 0, indent = 3, root = TRUE)

\S4method{tree_structure}{subcorpus}(x)

\S4method{tree_structure}{corpus}(x, s_attribute = NULL)
}
\arguments{
\item{x}{Object for which to visualise structure.}

\item{...}{Further arguments.}

\item{s_attribute}{Name of the s-attribute used for subsetting, will be
highlighted.}

\item{prefix}{Number of blank spaces.}

\item{indent}{Number of spaces to indent.}

\item{root}{Whether branch is root.}
}
\description{
Show the structure of s-attributes. If \code{x} is a \code{subcorpus}, the s-attribute
used for corpus subsetting is highlighted.
}
\examples{
xml_sample <- system.file(
  package = "GermaParl2",
  "extdata", "cwb", "indexed_corpora",
  "germaparl2mini"
)
if (nchar(xml_sample) > 0L && interactive()){
  use(pkg = "GermaParl2", corpus = "GERMAPARL2MINI")
  
  corpus("GERMAPARL2MINI") \%>\%
    tree_structure()
    
  corpus("GERMAPARL2MINI") \%>\%
    subset(speaker_name == "Konrad Adenauer") \%>\%
    tree_structure()
 
  corpus("GERMAPARL2MINI") \%>\%
    subset(speaker_name == "Konrad Adenauer") \%>\%
    subset(p) \%>\%
    tree_structure()
  
  corpus("GERMAPARL2MINI") \%>\%
    subset(ne_type) \%>\%
    tree_structure()
}
}
