% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.polywog.r
\name{plot.polywog}
\alias{plot.polywog}
\title{Univariate and bivariate fitted value plots}
\usage{
\method{plot}{polywog}(
  x,
  which = NULL,
  ask = FALSE,
  auto.set.par = TRUE,
  interval = TRUE,
  level = 0.95,
  FUN3D = c("contour", "filled.contour", "wireframe", "persp3d"),
  control.plot = list(),
  ...
)
}
\arguments{
\item{x}{a fitted model of class \code{"polywog"}, typically the output
of \code{\link{polywog}}.}

\item{which}{selection of variables to plot: a character vector containing
one or two names of raw input variables (see \code{x$varNames}).  May also
be a numeric vector corresponding to indices of \code{x$varNames}.
If \code{which = NULL}, a plot of each individual term will be generated.}

\item{ask}{logical: whether to display an interactive menu of terms to
select.}

\item{auto.set.par}{logical: whether to temporarily change the graphics
parameters so that multiple plots are displayed in one window (e.g., each
univariate plot when \code{which = NULL}).}

\item{interval}{logical: whether to display bootstrap confidence intervals
around each fitted value.  Not available for bivariate plots unless
\code{FUN3d = "persp3d"}.}

\item{level}{confidence level for the intervals.}

\item{FUN3D}{which plotting function to use to generate bivariate plots.
Valid options include \code{"\link{contour}"} (the default) and
\code{"\link{filled.contour}"}; \code{"\link[lattice]{wireframe}"}, which
requires the \pkg{lattice} package; and \code{"\link[rgl]{persp3d}"}, which
requires the \pkg{rgl} package.}

\item{control.plot}{list of arguments to be passed to the underlying
plotting functions (e.g., axis labels and limits).}

\item{...}{additional arguments to be passed to \code{\link{predVals}}.}
}
\value{
An object of class \code{preplot.polywog}, invisibly.  This is a
data frame generated by \code{\link{predVals}} that contains all information
used in plotting.
}
\description{
Generates plots of the relationship between input variables and the expected
value of the outcome, using \code{\link{predVals}} as a backend.
}
\details{
By default, a univariate plot generated by \code{plot.polywog} shows the
relationship between the selected input variable and the expected outcome
while holding all other covariates at "central" values (as in
\code{\link{predVals}}).  The values that the other variables are held out
can be changed by supplying additional arguments to \code{...}, as in the
examples below.

Similarly, a bivariate plot shows the relationship between two input
variables and the expected outcome while holding all else fixed.  If either
variable is binary or categorical, the plot will show the relationship
between one variable and the expected outcome across each value/level of the
other.
}
\examples{
## Using occupational prestige data
data(Prestige, package = "carData")
Prestige <- transform(Prestige, income = income / 1000)

## Fit a polywog model with bootstrap iterations
## (note: using low convergence threshold to shorten computation time of the
## example, *not* recommended in practice!)
set.seed(22)
fit1 <- polywog(prestige ~ education + income + type,
                data = Prestige,
                degree = 2,
                boot = 5,
                thresh = 1e-4)

## All univariate relationships
plot(fit1, n = 20)

## Predicted prestige across occupational categories
plot(fit1, which = "type",
     control.plot = list(xlab = "occupational category"))

## Predicted prestige by education across occupational categories
plot(fit1, which = c("education", "type"), n = 20)

## Joint effect of education and income
plot(fit1, which = c("education", "income"), n = 10)

## Bring up interactive menu
\dontrun{
plot(fit1, ask = TRUE)

  # displays menu:
  # Select one or two variable numbers (separated by spaces), or 0 to exit:

  # 1: education
  # 2: income
  # 3: type
}
}
\author{
Brenton Kenkel and Curtis S. Signorino
}
