% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workhorses.R, R/objfun.R
\docType{methods}
\name{partrans}
\alias{partrans}
\alias{partrans,ANY-method}
\alias{partrans,missing-method}
\alias{partrans,pomp-method}
\alias{partrans,objfun-method}
\title{partrans workhorse}
\usage{
\S4method{partrans}{pomp}(object, params, ..., dir = c("fromEst", "toEst"))

\S4method{partrans}{objfun}(object, ...)
}
\arguments{
\item{object}{an object of class \sQuote{pomp}, or of a class that extends \sQuote{pomp}.
This will typically be the output of \code{pomp}, \code{simulate}, or one of the \pkg{pomp} inference algorithms.}

\item{params}{a \code{npar} x \code{nrep} matrix of parameters.
Each column is treated as an independent parameter set, in correspondence with the corresponding column of \code{x}.}

\item{...}{additional arguments are ignored.}

\item{dir}{the direction of the transformation to perform.}
}
\value{
If \code{dir=fromEst}, the parameters in \code{params} are assumed to be on the estimation scale and are transformed onto the natural scale.
If \code{dir=toEst}, they are transformed onto the estimation scale.
In both cases, the parameters are returned as a named numeric vector or an array with rownames, as appropriate.
}
\description{
Performs parameter transformations.
}
\seealso{
Specification of parameter transformations: \code{\link{parameter_trans}}

More on \pkg{pomp} workhorse functions:
\code{\link{dinit}()},
\code{\link{dmeasure}()},
\code{\link{dprior}()},
\code{\link{dprocess}()},
\code{\link{emeasure}()},
\code{\link{flow}()},
\code{\link{pomp-package}},
\code{\link{rinit}()},
\code{\link{rmeasure}()},
\code{\link{rprior}()},
\code{\link{rprocess}()},
\code{\link{skeleton}()},
\code{\link{vmeasure}()},
\code{\link{workhorses}}
}
\concept{extending the pomp package}
\concept{low-level interface}
\concept{pomp workhorses}
