% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generation.time.R
\name{generation.time}
\alias{generation.time}
\title{Generation time}
\usage{
generation.time(A, ...)
}
\arguments{
\item{A}{projection matrix}

\item{\dots}{additional items are passed to \code{\link{splitA}} and are
used to split A into T and F matrices}
}
\value{
Generation time. If the transition matrix is singular, then NA is returned.
}
\description{
Calculates the generation time of a stage-classified matrix
}
\details{
see section 5.3.5 in Caswell (2001).
}
\examples{
generation.time(whale)
## fertilities in last column
generation.time(teasel, r=1:6, c=6)
## Plot 3 from Calathea
sapply(calathea[9:12], generation.time)

}
\references{
Caswell, H. 2001. Matrix population models: construction,
analysis, and interpretation, Second edition. Sinauer, Sunderland,
Massachusetts, USA.
}
\seealso{
see \code{\link{fundamental.matrix}} and \code{\link{net.reproductive.rate}}
for other age-specific traits
}
\author{
Chris Stubben
}
