% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TFR_projection.R
\name{TFR_projection}
\alias{TFR_projection}
\title{TFR_projection}
\usage{
TFR_projection(TFR_path, WRA_path, horizon, first_year_projection, ...)
}
\arguments{
\item{TFR_path}{character. Path to Fertility rates in a .txt file.}

\item{WRA_path}{character. Path to Women of Reproductive Age in a .txt file.}

\item{horizon}{numeric. The forecast horizon.}

\item{first_year_projection}{numeric. Year for the base population.}

\item{...}{additional arguments to be passed to \code{\link[forecast]{Arima}}.}
}
\value{
\code{TFR_projection} returns an object of class \code{fmforecast} with the forecast fertility rates and the components of \code{\link[demography]{forecast.fdm}}.
}
\description{
Forecasting total fertility rates.
}
\examples{

\donttest{

library(dplyr)

data(CR_fertility_rates_1950_2011)

#CR_fertility_rates_1950_2011 \%>\%
#write.table(.,
#file = "CR_fertility_rates_1950_2011.txt",
#sep = "\t",
#row.names = FALSE,
#col.names = TRUE,
#quote = FALSE)


data(CR_women_childbearing_age_1950_2011)

#CR_women_childbearing_age_1950_2011 \%>\%
#write.table(.,
#file = "CR_women_childbearing_age_1950_2011.txt",
#sep = "\t",
#row.names = FALSE,
#col.names = TRUE,
#quote = FALSE)

#result <- TFR_projection(TFR_path = "CR_fertility_rates_1950_2011.txt",
#WRA_path = "CR_women_childbearing_age_1950_2011.txt",
#omega_age = 115, first_year_projection = 2011, horizon = 2150)


}

}
\author{
Cesar Gamboa-Sanabria
}
