% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find.R
\name{find_label_male}
\alias{find_label_male}
\title{Identify Sex or Gender Labels Referring to Males}
\usage{
find_label_male(nms)
}
\arguments{
\item{nms}{A character vector}
}
\value{
An element of \code{nms} or \code{NULL}.
}
\description{
Given labels for sex or gender, try to infer
which (if any) refer to males.
If no elements look like a label for males,
or if two or more elements do,
then return \code{NULL}.
}
\examples{
find_label_male(c("Female", "Male")) ## one valid
find_label_male(c("0-4", "5-9"))     ## none valid
find_label_male(c("male", "m"))      ## two valid
}
\seealso{
\code{\link[=find_label_female]{find_label_female()}}, \code{\link[=find_var_sexgender]{find_var_sexgender()}}
}
