% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/POSetMaximals.R
\name{POSetMaximals}
\alias{POSetMaximals}
\title{Computing the maximal elements of a poset.}
\usage{
POSetMaximals(poset)
}
\arguments{
\item{poset}{An object of S4 class \code{POSet}.
Argument \code{poset} must be created by using any function contained in the package aimed at building object of S4 class \code{POSet}
(e.g. \code{\link[=POSet]{POSet()}}, \code{\link[=LinearPOSet]{LinearPOSet()}}, \code{\link[=ProductPOSet]{ProductPOSet()}}, ...) .}
}
\value{
A vector of character strings (the names of the maximal elements).
}
\description{
Computes the maximal elements of the input poset, i.e. those elements being strictly dominated by no other elements.
}
\examples{
elems <- c("a", "b", "c", "d")

dom <- matrix(c(
  "a", "b"
  ,
  "c", "b",
  "b", "d"
), ncol = 2, byrow = TRUE)

pos <- POSet(elements = elems, dom = dom)

mxs <- POSetMaximals(pos)

}
