% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_estim.R
\name{poso_estim_sir}
\alias{poso_estim_sir}
\title{Estimate the posterior distribution of individual parameters by SIR}
\usage{
poso_estim_sir(
  dat = NULL,
  prior_model = NULL,
  n_sample = 10000,
  n_resample = 1000,
  return_model = TRUE,
  nocb = FALSE
)
}
\arguments{
\item{dat}{Dataframe. An individual subject dataset following the
structure of NONMEM/rxode2 event records.}

\item{prior_model}{A \code{posologyr} prior population pharmacokinetics
model, a list of six objects.}

\item{n_sample}{Number of samples from the S-step}

\item{n_resample}{Number of samples from the R-step}

\item{return_model}{A boolean. Returns a rxode2 model using the estimated
ETAs if set to \code{TRUE}.}

\item{nocb}{A boolean. for time-varying covariates: the next observation
carried backward (nocb) interpolation style, similar to NONMEM.  If
\code{FALSE}, the last observation carried forward (locf) style will be used.
Defaults to \code{FALSE}.}
}
\value{
If \code{return_model} is set to \code{FALSE}, a list of one element: a
dataframe \verb{$eta} of ETAs from the posterior distribution, estimated by
Sequential Importance Resampling.
If \code{return_model} is set to \code{TRUE}, a list of the dataframe of the posterior
distribution of ETA, and a rxode2 model using the estimated distributions of
ETAs.
}
\description{
Estimates the posterior distribution of individual parameters by
Sequential Importance Resampling (SIR)
}
\examples{
# model
mod_run001 <- function() {
  ini({
    THETA_Cl <- 4.0
    THETA_Vc <- 70.0
    THETA_Ka <- 1.0
    ETA_Cl ~ 0.2
    ETA_Vc ~ 0.2
    ETA_Ka ~ 0.2
    prop.sd <- sqrt(0.05)
  })
  model({
    TVCl <- THETA_Cl
    TVVc <- THETA_Vc
    TVKa <- THETA_Ka

    Cl <- TVCl*exp(ETA_Cl)
    Vc <- TVVc*exp(ETA_Vc)
    Ka <- TVKa*exp(ETA_Ka)

    K20 <- Cl/Vc
    Cc <- centr/Vc

    d/dt(depot) = -Ka*depot
    d/dt(centr) = Ka*depot - K20*centr
    Cc ~ prop(prop.sd)
  })
}
# df_patient01: event table for Patient01, following a 30 minutes intravenous
# infusion
df_patient01 <- data.frame(ID=1,
                        TIME=c(0.0,1.0,14.0),
                        DV=c(NA,25.0,5.5),
                        AMT=c(2000,0,0),
                        EVID=c(1,0,0),
                        DUR=c(0.5,NA,NA))
# estimate the posterior distribution of population parameters
poso_estim_sir(dat=df_patient01,prior_model=mod_run001,
n_sample=1e3,n_resample=1e2)

}
