% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_grid.R
\name{create_grid}
\alias{create_grid}
\title{Create a Regularly Spaced Points Grid}
\usage{
create_grid(x, res)
}
\arguments{
\item{x}{an sf object, the spatial extent of this object is used to
create the regular grid.}

\item{res}{resolution of the grid (in map units).}
}
\value{
The output of the function is an sf object of regularly spaced
points with the extent of x.
}
\description{
This function creates a regular grid of points
from the extent of a given spatial object and a given resolution.
}
\examples{
library(sf)
g <- create_grid(x = n3_poly, res = 200000)
plot(st_geometry(g))
plot(st_geometry(n3_poly), border = "red", add = TRUE)
}
