% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dexpow.R, R/pexpow.R, R/qexpow.R, R/rexpow.R
\name{ExponentialPower}
\alias{ExponentialPower}
\alias{dexpow}
\alias{ExponentialPower}
\alias{pexpow}
\alias{ExponentialPower}
\alias{qexpow}
\alias{ExponentialPower}
\alias{rexpow}
\title{The Exponential Power Distribution}
\usage{
dexpow(x, mu = 0, sigma = 1, k = 0, log = FALSE)

pexpow(q, mu = 0, sigma = 1, k = 0, lower.tail = TRUE, log.p = FALSE)

qexpow(p, mu = 0, sigma = 1, k = 0, lower.tail = TRUE, log.p = FALSE)

rexpow(n, mu = 0, sigma = 1, k = 0)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mu, sigma}{location and scale parameters.}

\item{k}{shape parameter.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x ]}, otherwise, P[X > x].}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\description{
Density, distribution function,
quantile function and random generation for
the exponential power distribution with parameters mu, sigma and k.
}
\details{
The Exponential distribution has density

\eqn{f\left(x\right)=\left[\frac{e^{-\left(\frac{x-\mu}{\sigma}\right)}}{\left(1+e^{-\left(\frac{x-\mu}{\sigma}\right)}\right)^{2}}\right]}{f(x)=[exp(-(x-\mu)/\sigma)/(1+exp(-(x-\mu)/\sigma)))^2]},

where \eqn{-\infty<\mu<\infty} is the location paramether, \eqn{\sigma^2>0} the scale parameter and k the shape parameter.
}
\examples{
dexpow(1, 3, 4, 1)
pexpow(1, 3, 4, 1)
qexpow(0.2, 3, 4, 1)
rexpow(5, 3, 4, 1)
}
\references{
Lemonte A. and Bazán J.L.
}
