% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerShow.R
\name{showTSSdata}
\alias{showTSSdata}
\title{Function for displaying TSS distributions}
\usage{
showTSSdata(tss_data, main = NULL, xlab = NULL, sig_lvl = 0.05, ...)
}
\arguments{
\item{tss_data}{Numeric matrix of TSS values (one row per TSS). The row names
are used as names for the TSS.}

\item{main}{Title (default = NULL). A generic title is created by default.}

\item{xlab}{Label of x-axis (default = NULL). A generic label is created
by default.}

\item{sig_lvl}{Level of significance (default=0.05, must be >0 and <1).}

\item{...}{Add further specifications for \code{plot()}.}
}
\value{
\code{showTSSdata} No return value, called for side effects
(plotting).
}
\description{
\code{showTSSdata} - This function plots histograms of TSS data.
}
\examples{
showTSSdata(tss_data = getTSSdata_trees(tss = c("Colless", "Sackin"),
                treeList = lapply(1:20L, function(x) genYuleTree(10))),
                breaks=15)
}
