% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tssGetInfo.R
\name{getTSSnames}
\alias{getTSSnames}
\alias{getTSSsimple}
\alias{getTSScolors}
\alias{getTSSsafe_n}
\alias{getTSStype}
\alias{getTSSonly_bin}
\alias{getAllTSS}
\title{Get information on included tree shape statistics}
\usage{
getTSSnames(tss_shorts)

getTSSsimple(tss_shorts)

getTSScolors(tss_shorts)

getTSSsafe_n(tss_shorts)

getTSStype(tss_shorts)

getTSSonly_bin(tss_shorts)

getAllTSS(n = NULL, not_only_bin = FALSE, types = c("tss", "bali", "imbali"))
}
\arguments{
\item{tss_shorts}{Vector of short names (characters) of TSS contained in
\code{tssInfo}.}

\item{n}{Integer value or vector of integer values, that
specifies the number(s) of leaves.
If NULL (default), then \code{getAllSafeTSS} returns the short names of all
TSS contained in \code{tssInfo}.}

\item{not_only_bin}{Select TRUE if you also want to analyze non-binary trees
and therefore want to filter out any TSS that only work on binary trees.
Otherwise, select FALSE (default) if all TSS are applicable.}

\item{types}{Character vector, that specifies all permissible TSS types. The
vector may contain a subset of \code{c("tss", "bali", "imbali")} to indicate
if balance indices, imbalance indices or mere TSS should be included. By
default all types are permissible.}
}
\value{
\code{getTSSnames} Vector of characters/expressions.

\code{getTSSsimple} Vector of characters/expressions.

\code{getTSScolors} Vector of characters (color names).

\code{getTSSsafe_n} Numeric matrix, one row per TSS and two columns
with lower and upper limit.

\code{getTSStype} Vector of characters (types as factors).

\code{getTSSonly_bin} Logical vector.

\code{getAllTSS} Character vector of short names of TSS
contained in \code{tssInfo}.
}
\description{
\code{getTSSnames} - Returns the full names (character/expression) of the
TSS.

\code{getTSSsimple} - Returns the simple names (character/expression) of the
TSS.

\code{getTSScolors} - Returns the colors of the TSS.

\code{getTSSsafe_n} - Returns the ranges of n that can be safely used.

\code{getTSStype} - Returns the types of the TSS, i.e., whether they are
balance or imbalance indices, or simple tree shape statistics.

\code{getTSSonly_bin} - Returns TRUE/FALSE vector: TRUE if TSS is only for
binary trees and FALSE otherwise.

\code{getAllTSS} - Returns the short names of all TSS that are safe to
use for the specified \code{n}, have one of the specified \code{types} and
can be applied to (non-)binary trees (\code{not_only_bin}).
}
\examples{
getTSSnames(tss_shorts = c("Sackin", "Colless", "B1I"))
getTSSsimple(tss_shorts = c("Sackin", "Colless", "B1I"))
getTSScolors(tss_shorts = c("Sackin", "Colless", "B1I"))
getTSSsafe_n(tss_shorts = c("Sackin", "Colless", "B1I"))
getTSStype(tss_shorts = c("Sackin", "Colless", "B1I"))
getTSSonly_bin(tss_shorts = c("Sackin", "Colless", "B1I"))
getAllTSS(n = c(3,30))
}
