% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_curve_plot.R
\name{plot.power_curve}
\alias{plot.power_curve}
\alias{plot.power4test_by_n}
\alias{plot.power4test_by_es}
\title{Plot a Power Curve}
\usage{
\method{plot}{power_curve}(
  x,
  what = c("ci", "power_curve"),
  main = paste0("Power Curve ", "(Predictor: ", switch(x$predictor, n = "Sample Size", es
    = "Effect Size"), ")"),
  xlab = switch(x$predictor, n = "Sample Size", es = "Effect Size"),
  ylab = "Estimated Power",
  pars_ci = list(),
  type = "l",
  ylim = c(0, 1),
  ci_level = 0.95,
  ...
)

\method{plot}{power4test_by_n}(
  x,
  what = c("ci", "power_curve"),
  main = "Estimated Power vs. Sample Size",
  xlab = "Sample Size",
  ylab = "Estimated Power",
  pars_ci = list(),
  type = "l",
  ylim = c(0, 1),
  ci_level = 0.95,
  ...
)

\method{plot}{power4test_by_es}(
  x,
  what = c("ci", "power_curve"),
  main = paste0("Estimated Power vs. Effect Size / Parameter (", attr(x[[1]],
    "pop_es_name"), ")"),
  xlab = paste0("Effect Size / Parameter (", attr(x[[1]], "pop_es_name"), ")"),
  ylab = "Estiamted Power",
  pars_ci = list(),
  type = "l",
  ylim = c(0, 1),
  ci_level = 0.95,
  ...
)
}
\arguments{
\item{x}{The object to be plotted.
It can be a \code{power_curve} object,
the output of \code{\link[=power_curve]{power_curve()}}. It
can also be the output of
\code{\link[=power4test_by_n]{power4test_by_n()}} or
\code{\link[=power4test_by_es]{power4test_by_es()}}.}

\item{what}{A character vector of
what to include in the
plot. Possible values are
\code{"ci"} (confidence intervals
for the estimated sample size) and
\code{"power_curve"} (the crude power
curve, if available).
The default values depend on the
type of \code{x}.}

\item{main}{The title of the plot.}

\item{xlab, ylab}{The labels for the
horizontal and vertical axes,
respectively.}

\item{pars_ci}{A named list of
arguments to be passed to \code{\link[=arrows]{arrows()}}
to customize the drawing of the
confidence intervals.}

\item{type}{An argument of the
default plot method \code{\link[=plot.default]{plot.default()}}.
Default is \code{"l"}. See \code{\link[=plot.default]{plot.default()}}
for other options.}

\item{ylim}{A two-element numeric
vector of the range of the vertical
axis.}

\item{ci_level}{The level of
confidence of the confidence intervals,
if requested. Default is \code{.95}, denoting
95\%.}

\item{...}{Optional arguments.
Passed to \code{\link[=plot]{plot()}} when drawing
the base plot.}
}
\value{
The \code{plot}-methods return \code{x}
invisibly. They
are called for their side effects.
}
\description{
Plotting the results
in a 'power_curve' object, such as the
estimated power against sample size,
or the results of \code{\link[=power4test_by_n]{power4test_by_n()}}
or \code{\link[=power4test_by_es]{power4test_by_es()}}.
}
\details{
The \code{plot} method of \code{power_curve}
objects currently plots the relation
between estimated power and
the predictor. Other elements
can be requested (see the argument
\code{what}), and they can be customized
individually.
}
\examples{

# Specify the population model

model_simple_med <-
"
m ~ x
y ~ m + x
"

# Specify the effect sizes (population parameter values)

model_simple_med_es <-
"
y ~ m: l
m ~ x: m
y ~ x: s
"

# Simulate datasets to check the model

sim_only <- power4test(nrep = 10,
                       model = model_simple_med,
                       pop_es = model_simple_med_es,
                       n = 50,
                       fit_model_args = list(fit_function = "lm"),
                       do_the_test = FALSE,
                       iseed = 1234,
                       parallel = FALSE,
                       progress = FALSE)

# By n: Do a test for different sample sizes
# Set `parallel` to TRUE for faster, usually much faster, analysis
# Set `progress` to TRUE to display the progress of the analysis

out1 <- power4test_by_n(sim_only,
                        nrep = 10,
                        test_fun = test_parameters,
                        test_args = list(par = "y~x"),
                        n = c(25, 50, 100),
                        by_seed = 1234,
                        parallel = FALSE,
                        progress = FALSE)

pout1 <- power_curve(out1)
pout1
plot(pout1)

# By pop_es: Do a test for different population values of a model parameter
# Set `parallel` to TRUE for faster, usually much faster, analysis
# Set `progress` to TRUE to display the progress of the analysis

out2 <- power4test_by_es(sim_only,
                             nrep = 10,
                             test_fun = test_parameters,
                             test_args = list(par = "y~x"),
                             pop_es_name = "y ~ x",
                             pop_es_values = c(0, .3, .5),
                             by_seed = 1234,
                             parallel = FALSE,
                             progress = FALSE)

pout2 <- power_curve(out2)
plot(pout2)

}
\seealso{
\code{\link[=power_curve]{power_curve()}},
\code{\link[=power4test_by_n]{power4test_by_n()}}, and
\code{\link[=power4test_by_es]{power4test_by_es()}}.
}
