% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\name{validate}
\alias{validate}
\title{Validate a sample size analysis}
\usage{
validate(
  method,
  replications = 3000,
  sample = NULL,
  cores = NULL,
  cluster_type = "psock",
  verbose = TRUE
)
}
\arguments{
\item{method}{An object of class \code{Method} produced by running
\code{\link[=powerly]{powerly()}}.}

\item{replications}{A single positive integer representing the number of
Monte Carlo simulations to perform for the recommended sample size. The
default is \code{1000}. Whenever possible, a value of \code{10000} should be preferred
for a higher accuracy of the validation results.}

\item{sample}{A single positive integer representing the sample size to
perform the validation for. If \code{NULL} (the default) the validation will be
run for the sample size recommendation contained in the \code{method} argument
(i.e., the output of the \code{\link[=powerly]{powerly()}} function). Defaults to \code{NULL}.}

\item{cores}{A single positive positive integer representing the number of
cores to use for running the algorithm in parallel, or \code{NULL}. If \code{NULL} (the
default) or \code{1} the algorithm will run sequentially.}

\item{cluster_type}{A character string indicating the type of cluster to
create for running the algorithm in parallel. Possible values are \code{"psock"}
and \code{"fork"}. Note that the \code{"fork"} option is only available on Unix-like
systems. The default value is \code{"psock"}.}

\item{verbose}{A logical value indicating whether information about the
status of the validation should be printed while running. The default is
\code{TRUE}.}
}
\value{
An \code{\link[R6:R6Class]{R6::R6Class()}} instance of \code{Validation} class that contains the results
of the validation.

Main fields:
\itemize{
\item \strong{\verb{$sample}}: The sample size used for the validation.
\item \strong{\verb{$measures}}: The performance measures observed during validation.
\item \strong{\verb{$statistic}}: The statistic computed on the performance measures.
\item \strong{\verb{$percentile_value}}: The performance measure value at the desired percentile.
\item \strong{\verb{$validator}}: An \code{\link[R6:R6Class]{R6::R6Class()}} instance of \code{StepOne} class.
}

The \code{plot} S3 method can be called on the return value to visualize the
validation results (i.e., see \code{\link[=plot.Validation]{plot.Validation()}}).
\itemize{
\item \code{plot(validation)}
}
}
\description{
This function can be used to validate the recommendation obtained from a
sample size analysis.
}
\details{
The sample sizes used during the validation procedure is automatically
extracted from the \code{method} argument. User may also choose to provide a
specific sample size for the validation via the \code{sample} argument. In this
case, the validation will be run for the provided sample size instead.
Providing a specific \code{sample} value is akin to manually searching for an
optimal value.
}
\examples{
\donttest{# Perform a sample size analysis.
results <- powerly(
    range_lower = 300,
    range_upper = 1000,
    samples = 30,
    replications = 30,
    measure = "sen",
    statistic = "power",
    measure_value = .6,
    statistic_value = .8,
    model = "ggm",
    nodes = 10,
    density = .4,
    cores = 2,
    verbose = TRUE
)

# Validate the recommendation obtained during the analysis.
validation <- validate(results, cores = 2)

# Plot the validation results.
plot(validation)

# To see a summary of the validation procedure, we can use the `summary` S3 method.
summary(validation)
}

}
\seealso{
\code{\link[=plot.Validation]{plot.Validation()}}, \code{\link[=summary.Validation]{summary.Validation()}}, \code{\link[=powerly]{powerly()}}, \code{\link[=generate_model]{generate_model()}}
}
