% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{windstorm}
\alias{windstorm}
\title{Locations of windstorm peaks and tracks over the North Atlantic}
\format{
A data frame with 3133 rows and 4 variables

The variables are as follows:

\describe{
  \item{date}{date of peak, as class "Date"}
  \item{lon}{longitude, in degrees}
  \item{lat}{latitude, in degrees}
  \item{NAO}{North Atlantic Oscillation index}
}
}
\usage{
data(windstorm)
}
\description{
A dataset in windstorm peaks between 1st January 1979 and 31st December 2014
occurring in [-50, 33] longitude and [36, 77] latitude.
}
\examples{

data(windstorm)
plot(windstorm[,c("lon", "lat")])

}
\references{
Youngman, B. D., & Economou, T. (2017). Generalised additive point process models for natural 
hazard occurrence. Environmetrics, 28(4), e2444.
}
\keyword{datasets}
