% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_honduras.R
\docType{data}
\name{ppiHND2010}
\alias{ppiHND2010}
\title{Poverty Probability Index (PPI) lookup table for Honduras}
\format{
A data frame with 7 columns and 101 rows:
\describe{
\item{\code{score}}{PPI score}
\item{\code{nl100}}{National poverty line (100\%)}
\item{\code{nlFood}}{Food poverty line}
\item{\code{extreme}}{USAID extreme poverty}
\item{\code{ppp125}}{Below $1.25 per day purchasing power parity (2005)}
\item{\code{ppp250}}{Below $2.50 per day purchasing power parity (2005)}
\item{\code{ppp375}}{Below $3.75 per day purchasing power parity (2005)}
}
}
\source{
\url{https://www.povertyindex.org}
}
\usage{
ppiHND2010
}
\description{
Poverty Probability Index (PPI) lookup table for Honduras
}
\examples{
  # Access Honduras PPI table
  ppiHND2010

  # Given a specific PPI score (from 0 - 100), get the row of poverty
  # probabilities from PPI table it corresponds to
  ppiScore <- 50
  ppiHND2010[ppiHND2010$score == ppiScore, ]

  # Use subset() function to get the row of poverty probabilities corresponding
  # to specific PPI score
  ppiScore <- 50
  subset(ppiHND2010, score == ppiScore)

  # Given a specific PPI score (from 0 - 100), get a poverty probability
  # based on a specific poverty definition. In this example, the USAID
  # extreme poverty definition
  ppiScore <- 50
  ppiHND2010[ppiHND2010$score == ppiScore, "extreme"]

}
\keyword{datasets}
