% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createRisksetTable.R
\name{createRisksetTable}
\alias{createRisksetTable}
\title{Creation of summary-level riskset tables from individual-level data}
\usage{
createRisksetTable(
  data,
  indA,
  indX,
  indStatus,
  indTime,
  truncP = 1,
  shareEventTime = "no"
)
}
\arguments{
\item{data}{An individual-level dataset in the form of R data frame.}

\item{indA}{A column name indicating the exposure/treatment variable.}

\item{indX}{A vector of column names indicating the baseline covariates to be included in the propensity score model.}

\item{indStatus}{A column name indicating the non-censoring status (1 if observed and 0 if censored).}

\item{indTime}{A column name indicating the outcome variable, i.e., min(true event time, censoring time).}

\item{truncP}{A value between 0 and 1 indicating the percentile used for weight truncation. The default is 1, corresponding to no weight truncation.}

\item{shareEventTime}{If the data-contributing site would like to share a column of event times, then set \code{shareEventTime="yes"}. If not, then set \code{shareEventTime="no"}. By default,  \code{shareEventTime="no"}.}
}
\value{
A list of two summary-level riskset tables to be shared with the analysis center, under both the conventional inverse probability weights (i.e., $ipwTable) and the stabilized weights (i.e., $stabTable). If \code{shareEventTime="no"}, then a riskset table has 8 columns: total weights of exposed cases or events, total weights of cases or events, total weights of exposed individuals, total weights of unexposed individuals, total squared weights of exposed cases or events, total squared weights of unexposed cases or events, total squared weights of exposed individuals, total squared weights of unexposed individuals. If \code{shareEventTime="yes"}, then a riskset table further has a column of event times.
}
\description{
This function creates summary-level riskset tables from individual-level data at each data-contributing site, under both the conventional inverse probability weights and the stabilized weights. A logistic regression model is used to estimate the propensity scores with an option to do weight truncation. This is a function for data-contributing sites.
}
\examples{
#load an example dataset site1.RData in the package
#site1 contains individual-level data of data-contributing site 1
data(site1)
#data-contributing site 1 creates its two summary-level riskset tables
#with logistic propensity score model A~X1+X2+X3+X4+X5
#no weight truncation
#agree to share a column of event times
rsTb1=createRisksetTable(data=site1,indA="A",indX=c("X1","X2","X3","X4","X5"),
                        indStatus="status",indTime="time",truncP=1,shareEventTime="yes")
#print the first six rows of riskset table using conventional weights
head(rsTb1$ipwTable)
#print the first six rows of riskset table using stabilized weights
head(rsTb1$stabTable)

}
