% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateStratHR.R
\name{estimateStratHR}
\alias{estimateStratHR}
\title{Privacy-protecting estimation of overall hazard ratios using inverse probability weighted Cox models stratified on data-contributing sites}
\usage{
estimateStratHR(tableList, initialHR = 1, endpoint = Inf, confidence = 0.95)
}
\arguments{
\item{tableList}{A list of summary-level riskset tables shared by data-contributing sites. Each data-contributing site provides a list of two riskset tables; the first using the conventional inverse probability weights and the second using the stabilized weights. Data-contributing sites can obtain their summary-level riskset tables using the function \code{\link[ppmHR]{createRisksetTable}} in this package.}

\item{initialHR}{An initial value for hazard ratio when solving the stratified weighted partial likelihood score equation. The default is 1.}

\item{endpoint}{A value of the end of follow-up used to conduct sensitivity analysis. Observed events in the original data that occur after this value will be censored. The default is Inf, which means that we use the original data without conducting sensitivity analysis. For riskset tables that do not provide event times, endpoint should be left as the default Inf.}

\item{confidence}{A confidence level between 0 and 1. The default is 0.95 corresponding to a 95 per cent confidence interval.}
}
\value{
A matrix of inference results from inverse probability weighted Cox models stratified on data-contributing sites. The first and the second rows report the log hazard ratio estimate and associated robust sandwich standard error, hazard ratio estimate and associated normality-based confidence interval, under the conventional inverse probability weights and the stabilized weights, respectively.
}
\description{
This function estimates the overall hazard ratios using inverse probability weighted Cox models stratified on data-contributing sites, under both the conventional inverse probability weights and the stabilized weights. The robust sandwich variance estimation method is used for estimating the variance of the log hazard ratio estimates. The Breslow method is used to handle tied events. This is a function for the analysis center.
}
\examples{
#load example datasets in the package
#site1-3 contain individual-level data of data-contributing sites 1-3
data(site1)
data(site2)
data(site3)
#data-contributing sites 1-3 create summary-level riskset tables
#with logistic propensity score model A~X1+X2+X3+X4+X5
#no weight truncation
#agree to share event times
rsTb1=createRisksetTable(data=site1,indA="A",indX=c("X1","X2","X3","X4","X5"),
                        indStatus="status",indTime="time",truncP=1,shareEventTime="yes")
rsTb2=createRisksetTable(data=site2,indA="A",indX=c("X1","X2","X3","X4","X5"),
                        indStatus="status",indTime="time",truncP=1,shareEventTime="yes")
rsTb3=createRisksetTable(data=site3,indA="A",indX=c("X1","X2","X3","X4","X5"),
                        indStatus="status",indTime="time",truncP=1,shareEventTime="yes")
#analysis center estimates hazard ratio in a stratified IPW Cox model
#using summary-level riskset tables rsTb1-3 shared by data-contributing sites
estimateStratHR(list(rsTb1,rsTb2,rsTb3),initialHR=1,endpoint=Inf,confidence=0.95)
#sensitivity analysis at endpoint 20
estimateStratHR(list(rsTb1,rsTb2,rsTb3),initialHR=1,endpoint=20,confidence=0.95)

}
