% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pqlBLogist.R
\name{pqlBLogist}
\alias{pqlBLogist}
\title{The weighted Gauss-Newton estimators of the PQL in Logistic-GLMs}
\usage{ pqlBLogist(data,G,nk)
}
\arguments{
\item{data}{is a design matrix with uniform distribution and the response vector.}
\item{G}{is the number of subsets.}
\item{nk}{is the size of subsets.}

}
\value{
betaBW,betaBA,MSEW,MSEA}
\description{
The average weighted estimator and the unknown weighted  estimator of the PQL in  Logistic-GLMs through damped Gauss-Newton updates.
}
\examples{
G <- 20;n=1000;p=5; nk=50
b=runif(p, 0, 1)
beta =matrix(b,nrow=p)
X=matrix(rnorm(n*p),nrow=n)
L=X\%*\%beta
prob=1/exp(-(0.48+(L))+1)
y=1/(1+exp(-X))
y=(prob>runif(n))
y= ifelse((prob>runif(n)), 1, 0)
data=cbind(y,X)
pqlBLogist(data,G,nk)
}
