% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PC.R
\name{pqlLogist}
\alias{pqlLogist}
\title{pqlLogist}
\usage{ pqlLogist(data,G,nk)}
\arguments{
\item{data}{data is a highly correlated data set}
\item{G}{G is the number of nodes}
\item{nk}{n1 is  the length of each data subset}
}
\value{
 \item{betaW}{estimation value of betaW}
 \item{betaA}{estimation  value of betaA}
 \item{MSEW }{estimation of MSEW}
 \item{MSEA }{estimation of MSEA}
}
\description{
The average weighted estimator and the unknown weighted estimator of the PQL in Poisson-GLMS through damped Gauss-Newton}
\examples{
p<- 5;G<- 20;n<- 1000;nk=200
X<- matrix(runif(n*p, 0, 0.5), ncol = p)
beta =matrix(runif(p, 0, 1),nrow=p)
L=X\%*\%beta
y<- rpois(n, exp(L))
data=cbind(y,X)
pqlLogist(data,G,nk)
}
