# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @name Rho Koenker
#'
#' @param x generic vector
#' @param tau percentile
#' 
#' @return y vector, linear transformation by rho 
#' @keywords internal
#' @noRd
NULL

#' @name Psi M-quantile
#'
#' @param x generic vector
#' @param tau percentile
#' @param c tuning
#' 
#' @keywords internal
#' @noRd
NULL

#' @name D Psi M-quantile
#'
#' @description Derivative of psi M-quantile
#'
#' @param x generic vector
#' @param tau percentile
#' @param c tuning
#' 
#' @return y vector, linear transformation by second derivative m-rho
#' @keywords internal
#' @noRd
NULL

#' @name Psi ALS
#'
#' @description Psi asymetric least square
#'
#' @param x generic vector
#' @param tau percentile
#' 
#' @return y vector, linear transformation by ALS psi
#' @keywords internal
#' @noRd
NULL

#' @name D Psi ALS
#'
#' @description Derivative of Psi asymetric least square
#'
#' @param x generic vector
#' @param tau percentile
#' 
#' @return y vector, linear transformation by derivative ALS psi
#' @keywords internal
#' @noRd
NULL

#' @name Rho M-quantile
#'
#' @param x generic vector
#' @param tau percentile
#' @param c tuning
#' 
#' @return y vector, linear transformation by m-rho
#' @keywords internal
#' @noRd
rho_mq <- function(x, tau, c) {
    .Call(`_pqrfe_rho_mq`, x, tau, c)
}

#' @name Loss quantile regression
#' 
#' @description This function returns the core of quantile regression to be minimized
#'
#' @param beta initial values
#' @param x design matrix
#' @param y vector output
#' @param tau percentile
#' @param N sample size
#' @param d columns of x  
#' 
#' @return eta Numeric, sum of quantile regression
#' @keywords internal
#' @noRd
loss_qr_simple <- function(beta, x, y, tau, N, d) {
    .Call(`_pqrfe_loss_qr_simple`, beta, x, y, tau, N, d)
}

#' @name Loss quantile regression with fixed effects
#' 
#' @description This function returns the core of quantile regression with fixed effects to be minimized
#'
#' @param theta initial values
#' @param x design matrix
#' @param y vector output
#' @param z incident matrix
#' @param tau percentile
#' @param n N sample size
#' @param d columns of x
#' @param mm n columns of z   
#' 
#' @return eta Numeric, sum of quantile regression with fixed effects
#' @keywords internal
#' @noRd
loss_qrfe <- function(theta, x, y, z, tau, n, d, mm) {
    .Call(`_pqrfe_loss_qrfe`, theta, x, y, z, tau, n, d, mm)
}

#' @name Loss lasso quantile regression with fixed effects
#'
#' @description This function returns the core of lasso quantile regression with fixed effects to be minimized
#'
#' @param theta initial values
#' @param x design matrix
#' @param y vector output
#' @param z incident matrix
#' @param tau percentile
#' @param n N sample size
#' @param d columns of x
#' @param mm n columns of z  
#' @param lambda constriction parameter
#' 
#' @return eta Numeric, sum of lasso quantile regression with fixed effects
#' @keywords internal
#' @noRd
loss_qrlasso <- function(theta, x, y, z, tau, n, d, mm, lambda) {
    .Call(`_pqrfe_loss_qrlasso`, theta, x, y, z, tau, n, d, mm, lambda)
}

#' @name Loss M-quantile regression
#'
#' @description This function returns the core of M-quantile regression to be minimized
#'
#' @param beta initial values
#' @param x design matrix
#' @param y vector output
#' @param tau percentile
#' @param N sample size
#' @param d columns of x  
#' @param c tuning
#' 
#' @return eta Numeric, sum of M-quantile regression
#' @keywords internal
#' @noRd
loss_mqr <- function(beta, x, y, tau, N, d, c) {
    .Call(`_pqrfe_loss_mqr`, beta, x, y, tau, N, d, c)
}

#' @name Loss M-quantile regression with fixed effects
#'
#' @description This function returns the core of M-quantile regression with fixed effects to be minimized
#'
#' @param theta initial values
#' @param x design matrix
#' @param y vector output
#' @param z incident matrix
#' @param tau percentile
#' @param n N sample size
#' @param d columns of x
#' @param mm n columns of z 
#' @param c tuning
#' 
#' @return eta Numeric, sum of M-quantile regression with fixed effects
#' @keywords internal
#' @noRd
loss_mqrfe <- function(theta, x, y, z, tau, n, d, mm, c) {
    .Call(`_pqrfe_loss_mqrfe`, theta, x, y, z, tau, n, d, mm, c)
}

#' @name Loss lasso M-quantile regression with fixed effects
#' 
#' @description This function returns the core of lasso M-quantile regression with fixed effects to be minimized   
#'
#' @param theta initial values
#' @param x design matrix
#' @param y vector output
#' @param z incident matrix
#' @param tau percentile
#' @param n N sample size
#' @param d columns of x
#' @param mm n columns of z  
#' @param c tuning
#' @param lambda constriction parameter
#' 
#' @return eta Numeric, sum of lasso M-quantile regression with fixed effects
#' @keywords internal
#' @noRd
loss_mqrlasso <- function(theta, x, y, z, tau, n, d, mm, c, lambda) {
    .Call(`_pqrfe_loss_mqrlasso`, theta, x, y, z, tau, n, d, mm, c, lambda)
}

#' @name Loss expectile regression
#'
#' @description This function returns the core of expectile regression to be minimized   
#' 
#' @param beta initial values
#' @param x design matrix
#' @param y vector output
#' @param tau percentile
#' @param N sample size
#' @param d columns of x  
#' 
#' @return eta Numeric, sum of expectile regression
#' @keywords internal
#' @noRd
loss_er <- function(beta, x, y, tau, N, d) {
    .Call(`_pqrfe_loss_er`, beta, x, y, tau, N, d)
}

#' @name Loss expectile regression with fixed effects
#'
#' @description This function returns the core of expectile regression with fixed effects to be minimized   
#'
#' @param theta initial values
#' @param x design matrix
#' @param y vector output
#' @param z incident matrix
#' @param tau percentile
#' @param n N sample size
#' @param d columns of x
#' @param mm n columns of z  
#' 
#' @return eta Numeric, sum of expectile regression with fixed effects
#' @keywords internal
#' @noRd
loss_erfe <- function(theta, x, y, z, tau, n, d, mm) {
    .Call(`_pqrfe_loss_erfe`, theta, x, y, z, tau, n, d, mm)
}

#' @name Loss lasso expectile regression with fixed effects
#' 
#' @description This function returns the core of lasso expectile regression with fixed effects to be minimized   
#'  
#' @param theta initial values
#' @param x design matrix
#' @param y vector output
#' @param z incident matrix
#' @param tau percentile
#' @param n N sample size
#' @param d columns of x
#' @param mm n columns of z  
#' @param lambda constriction parameter
#' 
#' @return eta Numeric, sum of lasso expectile regression with fixed effects
#' @keywords internal
#' @noRd
loss_erlasso <- function(theta, x, y, z, tau, n, d, mm, lambda) {
    .Call(`_pqrfe_loss_erlasso`, theta, x, y, z, tau, n, d, mm, lambda)
}

