% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeTablePlot.R
\name{makeTablePlot}
\alias{makeTablePlot}
\title{Tabularize the essential result of the predictMe package.}
\usage{
makeTablePlot(xc = NULL, measColumn = NULL, plot = FALSE, plotCellRes = TRUE)
}
\arguments{
\item{xc}{A data.frame with exactly two columns, one of the columns must be the categorized measured outcome, the other column must be the categorized predicted outcome.}

\item{measColumn}{A single integer number that denotes which of the two columns of function argument 'x' contains the measured outcome.}

\item{plot}{Logical value, defaults to FALSE. If set TRUE, two complementary plots will be part of the list that this function returns.}

\item{plotCellRes}{Logical value, defaults to TRUE (is ignored if function argument 'plot' is set FALSE). If set FALSE, the heatmap is returned without frequency results in the cellls.}
}
\value{
a list with five or seven items (see \strong{Details}):
\enumerate{
\item totalCountTable A table with the total counts.
\item rowSumTable A table with proportions that sum up to 1, per row (summing across columns).
\item colSumTable A table with proportions that sum up to 1, per column (summing across rows).
\item rowSumTable_melt The rowSumTable, reformated by the function melt of the reshape2 package.
\item colSumTable_melt The colSumTable, reformated by the function melt of the reshape2 package.
\item rowSumTable_plot The rowSumTable_melt data, plotted by the function ggplot of the ggplot2 package.
\item colSumTable_plot The colSumTable_melt data, plotted by the function ggplot of the ggplot2 package.
}
}
\description{
Provides the essential result of the predictMe package, three tables, and, optionally, two plots.
}
\details{
The c in 'xc' stands for categorized, meaning that the outcome values are expected to have been categorized, so that both columns contain the exact same categories, and are of the class factor.

Columns 1 and 2 of the output 'xTrans' from function \code{\link{binBinary}} and from function \code{\link{binContinuous}} provide the expected input of this \code{makeTablePlot} function (see \strong{Examples}).

The returned list will contain 7 items, if function argument 'plot' is set TRUE, if FALSE, it will return the first 5 items (see \strong{Values}).
}
\examples{
# Simulate data set with continuous outcome (use all default values)
dfContinuous <- quickSim()
# Use multiple linear regression as algorithm to predict the outcome.
lmRes <- lm(y~x1+x2,data=dfContinuous)
# Extract measured outcome and the predicted outcome (fitted values)
# from the regression output, put both in a data.frame.
lmDf <- data.frame(measOutcome=dfContinuous$y,
                   fitted=lmRes$fitted.values)
# Apply function binBinary
x100c <- binContinuous(x=lmDf, measColumn = 1, binWidth = 20)
# Apply function makeDiffPlot, using columns 1 and 2 from x100c[["xTrans"]]
# The first of columns 1 and 2 contains the measured outcome values.
tp <- makeTablePlot(x100c[["xTrans"]][,1:2], measColumn = 1, plot = TRUE)
# tp is a list with 7 items, items 6 and 7 are the plots that represent
# the numeric information of items 2 and 3 (and 4 and 5, which merely have
# a different format).
# Display item 6 (plot no.1). Perfect performance if the diagonal cells all
# contain the value 1.
tp$rowSumTable_plot
}
\references{
\insertRef{ggplot2Wickham}{predictMe}

\insertRef{reshape2Wickham}{predictMe}
}
\author{
Marcel Miché
}
