% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stv_wig.R
\name{stv.wig}
\alias{stv.wig}
\title{STV election count using WIG as for Scottish Council elections
calculated to 5 places of decimals as used for those elections}
\usage{
stv.wig(
  votedata,
  outdirec = tempdir(),
  plot = TRUE,
  webdisplay = FALSE,
  interactive = FALSE,
  messages = TRUE,
  timing = FALSE,
  map = FALSE
)
}
\arguments{
\item{votedata}{File with vote data}

\item{outdirec}{Needs to be set for permanent record of results
(press return to continue to next stage)}

\item{plot}{If =TRUE (default) produces plots of count and webpages in outdirec}

\item{webdisplay}{If =TRUE displays plots and statistics as web pages}

\item{interactive}{If =TRUE reports and pauses at each stage of the count}

\item{messages}{If=TRUE prints 1-line initial and final reports}

\item{timing}{Whether to report computing time at each stage}

\item{map}{Link to a map or other URL associated with election}
}
\value{
A list containing votes at each stage, + optional web pages; for details see manual pref_pkg_manual.pdf (section 3)
}
\description{
STV election count using WIG as for Scottish Council elections
calculated to 5 places of decimals as used for those elections
}
\examples{
hc12wig=stv.wig(hc12,plot=FALSE,messages=FALSE)
nws17wig=stv.wig(nws17,plot=FALSE)
p17wig=stv.wig(p17,plot=FALSE)
cnc17wig=stv.wig(cnc17,plot=FALSE,timing=TRUE)

}
