% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pref_summaries.R
\name{pref_irv}
\alias{pref_irv}
\title{Compute the instant-runoff voting winner for a set of preferences.}
\usage{
pref_irv(x, preferences_col = NULL, frequency_col = NULL)
}
\arguments{
\item{x}{A vector of preferences, or a tibble with a column of preferences.}

\item{preferences_col}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> When \code{x} is a
\code{tibble}, the column containing the preferences.}

\item{frequency_col}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> When \code{x} is a
\code{tibble}, the column containing the frequency of the preferences. If not
provided, each row is considered to be observed a single time.}
}
\value{
A list containing:
\describe{
\item{winner}{The winning candidate(s) after IRV counting}
\item{rounds}{A list of tibbles, each containing vote tallies for each round}
\item{eliminated}{Character vector of eliminated candidates in order}
}
}
\description{
A very rudimentary implementation of the IRV counting algorithm. It does not handle
ties elegantly, and should only be used for demonstration purposes. This implementation
eliminates all candidates with the fewest first-choice votes in each round until one
candidate has a majority or fewer than two candidates remain.
}
\examples{
# Multi-round election with four candidates
prefs <- preferences(c(
  "alice > bob > charlie > david",
  "alice > bob > charlie > david",
  "alice > charlie > bob > david",
  "bob > alice > charlie > david",
  "bob > charlie > alice > david",
  "bob > charlie > alice > david",
  "charlie > david > alice > bob",
  "charlie > david > bob > alice",
  "david > charlie > bob > alice",
  "david > charlie > bob > alice"
))
result <- pref_irv(prefs)
result$winner # Final winner after elimination rounds
result$rounds # Vote tallies for each round

# Using aggregated data frame
df <- tibble::tibble(
  prefs = preferences(c(
    "alice > bob > charlie > david",
    "alice > charlie > bob > david",
    "bob > alice > charlie > david",
    "bob > charlie > alice > david",
    "charlie > david > alice > bob",
    "charlie > david > bob > alice",
    "david > charlie > bob > alice"
  )),
  freq = c(2, 1, 1, 2, 1, 1, 2)
)
pref_irv(df, prefs, freq)
}
