% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pref_tools.R
\name{pref_omit}
\alias{pref_omit}
\title{Remove specified items from preferences.}
\usage{
pref_omit(x, items)
}
\arguments{
\item{x}{A vector of \code{\link{preferences}}.}

\item{items}{The names of the items which should be removed from the preferences in \code{x}.}
}
\value{
A new vector of preferences, but with \code{items} removed from each selection.
}
\description{
Remove specified items from preferences.
}
\examples{
# Remove 'b'
pref_omit(preferences(c("a > b > c", "b > c > a")), "b")
# Remove 'b' and 'd'
pref_omit(preferences(c("a > b > c > d", "b > c > a > d")), c("b", "d"))
}
