% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/last_o2.R
\encoding{UTF-8}
\name{last_o2}
\alias{last_o2}
\title{Extract latest O2 values}
\usage{
last_o2(file, n_last = 10)
}
\arguments{
\item{file}{a character string. The filepath for the file to be read.}

\item{n_last}{integer. The number of O2 values to extract and return. Default is 10.}
}
\value{
A vector of numeric O2 values with a length of \code{n_last}.
}
\description{
Extracts the last O2 values from a PreSens text file.
}
\examples{
\dontrun{
file <- system.file('extdata', 'all_o2_units.txt', package = 'presens')
last_o2(file)
last_o2(file, n_last = 5)
}

}
\author{
Matthew A. Birk, \email{matthewabirk@gmail.com}
}
\seealso{
\code{\link{import_o2}}
}

