% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/presmTP.R
\name{presmTP}
\alias{presmTP}
\title{Methods for estimation of transition probabilities in the illness-death model}
\usage{
presmTP(data, s, method = "uns", estimand = "S",
  bw.selec = "plug-in", fixed.bw = NULL, bound = "none")
}
\arguments{
\item{data}{A numeric value to be squared}

\item{s}{The first time for obtaining estimates for the transition
probabilities.}

\item{method}{The method used to compute the transition probabilities.
Possible options are \code{"uns"}, \code{"np"} \code{"logit"}, \code{"logit.gam"},
\code{"probit"} and \code{"cauchit"}. Defaults to \code{"uns"}.}

\item{estimand}{An optional character string identifying the function to estimate: "S" 
for survival function and "H" for cumulative hazard function. Defaults to "S".}

\item{bw.selec}{An optional (partially matched) character string specifying the method of 
bandwidth selection. "fixed" if no bandwidth selection is done, in which case the bandwidth(s)
given by the fixed.bw argument is (are) used, "plug-in" for plug-in bandwidth selection and
"bootstrap" for bootstrap bandwidth selection. Defaults to "fixed".}

\item{fixed.bw}{An optional numeric vector with the fixed bandwidth(s) used when the value of
the bw.selec argument is "fixed". It must be of length 1 for estimating survival and cumulative
hazard functions, and of length 2 for density and hazard functions (in this case, the first element
is the presmoothing bandwidth).}

\item{bound}{An optional numeric vector with the fixed bandwidth(s) used when the value of the bw.selec
argument is "fixed". It must be of length 1 for estimating survival and cumulative hazard functions, and
of length 2 for density and hazard functions (in this case, the first element is the presmoothing bandwidth).}
}
\value{
An object of class "pstp" and one of the following classes: \code{"uns"}, 
\code{"np"}, \code{"logit"}, \code{"logit.gam"},
\code{"probit"} and \code{"cauchit"}. Objects are implemented as a list with elements:
\item{est0}{data.frame with estimates of the transition probabilities 0->0, 0->1 and 0->2.}
\item{est1}{data.frame with estimates of the transition probabilities 1->1 and 1->2.}
\item{s}{The first time for obtaining estimates for the transition probabilities.}
\item{callp}{The expression of the estimated probability.}
\item{call}{A call object.}
}
\description{
This function is used to obtain unsmoothed and presmoothed estimates of
the transition probabilities in the illness-death model.
}
\examples{

#Unsmoothed
res1<- presmTP(data = colonIDM, s = 365,method = "uns" )
res1$est0$t
res1$est0$p02
res1$est1$t
summary(res1, state_ini=1, time=365*1:5)
plot(res1)
res1$call
class(res1)
#Nonparametric
res2<- presmTP(data = colonIDM, s = 365,method = "np" )
res3<- presmTP(data = colonIDM, s = 365,method = "np", estimand="S")
res4<- presmTP(data = colonIDM, s = 365,method = "np", estimand="H")
res5<- presmTP(data = colonIDM, s = 365,method = "np", 
               bw.selec="fixed", fixed.bw=30)
#Presmoothed - Logit
res6<- presmTP(data = colonIDM, s = 365,method = "logit" )
summary(res6, state_ini=1, time=365*1:5)
#Presmoothed - Logit GAM
res7<- presmTP(data = colonIDM, s = 365,method = "logit.gam" )



}
\references{
Aalen O. O., Johansen S. (1978) An Empirical Transition Matrix for
Nonhomogeneous Markov Chains Based on Censored Observations. Scandinavian
Journal of Statistics 5(3), 141--150.

Cao, R., Lopez-de-Ullibarri, I., Janssen, P. and Veraverbeke, N. (2005). Presmoothed Kaplan-Meier 
and Nelson-Aalen estimators, Journal of Nonparametric Statistics, 17, 31-56.

Meira-Machado L. F., de Una-Alvarez J. and Cadarso-Suarez C. (2006).
Nonparametric estimation of transition probabilities in a non-Markov
illness-death model. Lifetime Data Anal 12(3), 325--344.

Lopez-de-Ullibarri, I and Jacome, M. A. (2013). survPresmooth: An R Package for Presmoothed
Estimation in Survival Analysis, Journal of Statistical Software, 54(11), 1-26. 
URL: http://www.jstatsoft.org/v54/i11/.
de Una-Alvarez J. and Meira-Machado L. (2015). Nonparametric estimation
of transition probabilities in a non-Markov illness-death model:
a comparative study. Biometrics 71, 364--375.

Meira-Machado, L. (2016). Smoothed landmark estimators of the transition probabilities, 
SORT-Statistics and Operations Research Transactions, 40, 375-398.
}
\author{
Gustavo Soutinho, Luis Meira-Machado, Pedro Oliveira.
}
