% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recursivehstep.R
\name{recursive_hstep_fast}
\alias{recursive_hstep_fast}
\title{Forecasting h-steps ahead using Recursive Least Squares Fast}
\usage{
recursive_hstep_fast(y, x, pi0, h)
}
\arguments{
\item{y}{n x 1 Outcome series, which should be numeric and one dimensional.}

\item{x}{n x p Predictor matrix (intercept would be added automatically).}

\item{pi0}{Fraction of the sample, which should be within 0 and 1.}

\item{h}{Number of steps ahead to predict, which should be a positive integer.}
}
\value{
Series of residuals estimated
}
\description{
Consider the following LS-fitted Model with intercept:
y_(t+h) = beta_0 + x_t * beta + u_(t+h)
which is used to generate out-of-sample forecasts of y, h-steps ahead (h=1,2,3,. . . ).
It calculates the recursive residuals starting from the first (n * pi0) data points, where n is the total number of data points.
}
\details{
recursive_hstep_fast is the fast version that avoids the recursive calculation of inverse of the matrix using Sherman-Morrison formula.
recursive_hstep_slow is the slow version that calculates the standard OLS recursively.
}
\examples{
x<- rnorm(15);
y<- x+rnorm(15);
temp1 <- recursive_hstep_fast(y,x,pi0=0.5,h=1);
}
\author{
Rong Peng, \email{r.peng@soton.ac.uk}
}
