% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{arg_match0_no_na_error_message}
\alias{arg_match0_no_na_error_message}
\title{Error Message For \code{NA} Argument For Non-missing List}
\usage{
arg_match0_no_na_error_message(
  arg,
  values,
  arg_nm = rlang::caller_arg(arg),
  error_call = rlang::caller_env()
)
}
\arguments{
\item{arg}{A symbol referring to an argument accepting strings.}

\item{values}{A character vector of possible values that \code{arg} can take.}

\item{arg_nm}{Same as \code{error_arg}.}

\item{error_call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}
}
\value{
An error message if the argument provided is \code{NA}
if a non-missing list is provided. Else if will return \code{NULL} invisibly,
regardless if \code{arg} has a match with the elements in \code{values} or not.
}
\description{
Provides an error message if the argument provided is \code{NA}
if a non-missing list is provided
}
\examples{
# Error as input is NA but value list provided has no NA
input = NA
try(arg_match0_no_na_error_message(input, values = c("female","male")))

# No error as value list provided has NA
input = NA
arg_match0_allow_na(input, values = c("female","male", NA))

# No error as input is not NA
input = "male"
arg_match0_allow_na(input, values = c("female","male", NA))
}
\seealso{
\code{\link[rlang]{caller_arg}}, \code{\link[rlang]{stack}}
 \code{\link[cli]{cli_abort}}
}
