% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cad_consortium_ptp.R
\name{calculate_cad1_2011_ptp}
\alias{calculate_cad1_2011_ptp}
\title{Calculate 2011 CAD1 Basic PTP for obstructive CAD}
\usage{
calculate_cad1_2011_ptp(
  age,
  sex,
  chest_pain_type,
  label_sex_male = c("male"),
  label_sex_female = c("female"),
  label_sex_unknown = c(NA, NaN),
  label_cpt_nonanginal = c("nonanginal"),
  label_cpt_atypical = c("atypical"),
  label_cpt_typical = c("typical"),
  label_cpt_unknown = c(NA, NaN)
)
}
\arguments{
\item{age}{Input numeric value to indicate the age of the patient in years.}

\item{sex}{The value of variable in the parameters \code{label_sex_male},
\code{label_sex_female} and \code{label_sex_unknown}.}

\item{chest_pain_type}{The value of variable in the parameters,
\code{label_cpt_nonanginal}, \code{label_cpt_atypical}, \code{label_cpt_typical} and
\code{label_cpt_unknown}.}

\item{label_sex_male}{Label(s) for definition(s) of male sex.
Default: \code{c("male")}}

\item{label_sex_female}{Label(s) for definition(s) of female sex.
Default: \code{c("female")}}

\item{label_sex_unknown}{Label(s) for definition(s) of missing sex.
Default: \code{c(NA, NaN)}}

\item{label_cpt_nonanginal}{Label(s) for patient having nonanginal or non-specific chest pain.
Default: \code{c("nonanginal")}}

\item{label_cpt_atypical}{Label(s) for patient having atypical chest pain.
Default: \code{c("atypical")}}

\item{label_cpt_typical}{Label(s) for patient having typical chest pain.
Default: \code{c("typical")}}

\item{label_cpt_unknown}{Label(s) for patient having unknown chest pain type symptoms.
Default: \code{c(NA, NaN)}}
}
\value{
A numeric value representing the patient's PTP for obstructive CAD
based on the 2011 CAD Consortium 1 (CAD1) basic model.
}
\description{
This function returns a patient's
pre-test probability (PTP) of obstructive
coronary artery disease based on the
2011 CAD Consortium 1 (CAD1) basic model.
}
\details{
The predictive model is based on
patients from 14 hospitals in Europe and the United States.

This model is also called the updated Diamond-Forrester model.
}
\examples{
# 40 year old female with typical chest pain
calculate_cad1_2011_ptp(
    age = 40,
    sex = "female",
    chest_pain_type = "typical"
)
}
