% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esc_2019_conference_ptp.R
\name{calculate_esc_2019_ptp}
\alias{calculate_esc_2019_ptp}
\title{Calculate ESC 2019 PTP for obstructive CAD}
\usage{
calculate_esc_2019_ptp(
  age,
  sex,
  have_dyspnoea,
  chest_pain_type,
  output = c("grouping", "numeric", "percentage"),
  label_sex_male = c("male"),
  label_sex_female = c("female"),
  label_sex_unknown = c(NA, NaN),
  label_have_dyspnoea_no = c("no"),
  label_have_dyspnoea_yes = c("yes"),
  label_have_dyspnoea_unknown = c(NA, NaN),
  label_cpt_no_chest_pain = c("no chest pain"),
  label_cpt_nonanginal = c("nonanginal"),
  label_cpt_atypical = c("atypical"),
  label_cpt_typical = c("typical"),
  label_cpt_unknown = c(NA, NaN)
)
}
\arguments{
\item{age}{Input integer value to indicate the age of the patient in years.}

\item{sex}{The value of variable in the parameters \code{label_sex_male},
\code{label_sex_female} and \code{label_sex_unknown}.}

\item{have_dyspnoea}{The value of variable in the parameters \code{label_have_dyspnoea_no},
\code{label_have_dyspnoea_yes} and \code{label_have_dyspnoea_unknown}.}

\item{chest_pain_type}{The value of variable in the parameters \code{label_cpt_no_chest_pain},
\code{label_cpt_nonanginal}, \code{label_cpt_atypical}, \code{label_cpt_typical} and
\code{label_cpt_unknown}.}

\item{output}{Input text to indicate the how pre-test
probability results be expressed
Default: c("grouping", "numeric", "percentage")
\itemize{
  \item grouping means the PTP will be expressed as Low, Intermediate and High.
  \itemize{
     \item low if PTP is less than 5\%.
     \item intermediate if PTP is in between 5\% to 15\%.
     \item high if PTP is more than 15\%.
  }
  \item numeric means the PTP will be expressed as an integer probability (0-100).
  \item percentage means the PTP will be expressed as percentage text (0-100\%).
}}

\item{label_sex_male}{Label(s) for definition(s) of male sex.
Default: \code{c("male")}}

\item{label_sex_female}{Label(s) for definition(s) of female sex.
Default: \code{c("female")}}

\item{label_sex_unknown}{Label(s) for definition(s) of missing sex.
Default: \code{c(NA, NaN)}}

\item{label_have_dyspnoea_no}{Label(s) for patient having no dyspnoea symptoms.
Default: \code{c("no")}}

\item{label_have_dyspnoea_yes}{Label(s) for patient having dyspnoea symptoms.
Default: \code{c("yes")}}

\item{label_have_dyspnoea_unknown}{Label(s) for patient having unknown dyspnoea symptoms.
Default: \code{c(NA, NaN)}}

\item{label_cpt_no_chest_pain}{Label(s) for patient having no chest pain.
Default: \code{c("no chest pain")}}

\item{label_cpt_nonanginal}{Label(s) for patient having nonanginal or non-specific chest pain.
Default: \code{c("nonanginal")}}

\item{label_cpt_atypical}{Label(s) for patient having atypical chest pain.
Default: \code{c("atypical")}}

\item{label_cpt_typical}{Label(s) for patient having typical chest pain.
Default: \code{c("typical")}}

\item{label_cpt_unknown}{Label(s) for patient having unknown chest pain type symptoms.
Default: \code{c(NA, NaN)}}
}
\value{
An integer, percentage or category representing the patient's PTP for obstructive CAD
based on the ESC 2019 guidelines.
See parameter option \code{output} for more information.
}
\description{
This function returns a patient's
pre-test Probability (PTP) of obstructive
coronary artery disease (CAD) based on the
European Society of Cardiology (ESC) 2019 guidelines.
}
\details{
The predictive model used to create the guidelines are based on
patients from European countries with low cardiovascular disease (CVD) risk.

If the patient has both dyspnoea and a particular
chest pain type (typical, atypical, nonanginal),
The chest pain type will take precedence over dyspnoea.
}
\examples{
# 35 year old female with typical chest pain
calculate_esc_2019_ptp(
    age = 35,
    sex = "female",
    have_dyspnoea = "no",
    chest_pain_type = "typical",
    output = "percentage"
)

# 75 year old male with only dyspnoea
calculate_esc_2019_ptp(
    age = 75,
    sex = "male",
    have_dyspnoea = "yes",
    chest_pain_type = "no chest pain",
    output = "percentage"
)
}
